% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/session.R
\name{do_once}
\alias{do_once}
\title{Perform a task once in an R session}
\usage{
do_once(
  task,
  option,
  hint = c("You will not see this message again in this R session. ",
    "If you never want to see this message, ",
    sprintf("you may set options(\%s = FALSE) in your .Rprofile.", option))
)
}
\arguments{
\item{task}{Any R code expression to be evaluated once to perform a task,
e.g., \code{warning('Danger!')} or \code{message('Today is ', Sys.Date())}.}

\item{option}{An R option name. This name should be as unique as possible in
\code{\link{options}()}. After the task has been successfully performed,
this option will be set to \code{FALSE} in the current R session, to
prevent the task from being performed again the next time when
\code{do_once()} is called.}

\item{hint}{A character vector to provide a hint to users on how not to
perform the task or see the message again in the current R session. Set
\code{hint = ""} if you do not want to provide the hint.}
}
\value{
The value returned by the \code{task}, invisibly.
}
\description{
Perform a task once in an R session, e.g., emit a message or warning. Then
give users an optional hint on how not to perform this task at all.
}
\examples{
do_once(message("Today's date is ", Sys.Date()), "xfun.date.reminder")
# if you run it again, it will not emit the message again
do_once(message("Today's date is ", Sys.Date()), "xfun.date.reminder")

do_once({
    Sys.sleep(2)
    1 + 1
}, "xfun.task.1plus1")
do_once({
    Sys.sleep(2)
    1 + 1
}, "xfun.task.1plus1")
}
