\name{xkcdline}
\alias{xkcdline}
\title{
Draws handwritten lines
}
\description{
  This function draws ggplot2 segments or circles in a handwritten style.
  }
  \usage{
xkcdline(mapping, data, typexkcdline = "segment", mask = TRUE, ...) 
}

\arguments{
  \item{mapping}{Mapping between variables and aesthetics generated by
  aes. See Details.}
  \item{data}{Dataset used in this layer.}
  \item{typexkcdline}{A string value. If it is \code{segment}, it draws
  a segment. If it is \code{circunference}, it plots a circunference.}
  \item{mask}{Logical. If it is true, it erases the pictures that are
  under the line.}
  \item{...}{Optional arguments.}
  
}
\details{
  It draws a segment or a circunference in a XKCD style.
  If it is a segment, the following aesthetics are required:
 \enumerate{
   \item xbegin: x position of the point from.
   \item ybegin: y position of the point from.
   \item xend: x position of the point to.
   \item yend: y position of the point to.
 }

   If it is a circunference, the following aesthetics are required:
 \enumerate{
   \item x: x position of the center.
   \item y: y position of the center.
   \item diameter: diameter of the circunference.
 }
 
  Additionally, you can use the aesthetics of \code{geom_path},
  \code{pointssegment} and \code{pointscircunference}.
  

}
\value{
  A ggplot layer.
}
% \references{

%  }
% \author{
% Emilio Torres Manzanera
% }
% \note{
%  Generic function.
% }
\seealso{
  \code{\link[ggplot2]{aes}},
  \code{\link[ggplot2]{geom_path}},
  \code{\link{pointssegment}},
  \code{\link{pointscircunference}}
}
\examples{
data <- data.frame(x1=c(1,2), y1=c(10,20), xend=c(2.5,0.5),
yend=c(20,10), model=c("low","high"))

ggplot() + xkcdline(mapping=aes(xbegin=x1 +y1, ybegin=y1, xend =xend, yend= yend,
color = model), data=data)

ggplot() + xkcdline(mapping=aes(xbegin=x1 +y1, ybegin=y1, xend =xend, yend= yend,
color = model), data=data) + facet_grid(. ~ model)

ggplot() + xkcdline(mapping=aes(x=x1 +y1, y=y1, diameter =xend), data=data, type="circunference") 

}

%\keyword{ manip }