% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validate_xltemplate.R
\name{validate_xltemplate}
\alias{validate_xltemplate}
\title{Validate an xlsx template file to use in \code{\link[=xlsx_cutter]{xlsx_cutter()}}}
\usage{
validate_xltemplate(
  template_file,
  template_sheet = 1,
  marker_open = "{{",
  marker_close = "}}",
  minimal = FALSE,
  error = FALSE
)
}
\arguments{
\item{template_file}{path to the template file to use as a model to parse the
xlsx files in \code{data_folder}}

\item{template_sheet}{sheet id of the template file to use as a model to
parse the xlsx files in \code{data_folder}}

\item{marker_open, marker_close}{character marker to mark the variables to
extract in the \code{template_file}}

\item{minimal}{Logical (default to \code{FALSE}) saying whether the template
should contain only variables delimited by markers and nothing else, or
if extra text can be included (and ignored)}

\item{error}{Logical (defaults to \code{TRUE}) saying whether failed validations
should result in an error (\code{TRUE}) or a warning (\code{FALSE})}
}
\value{
\code{TRUE} if the template is valid, \code{FALSE} otherwise
}
\description{
Validate an xlsx template file to use in \code{\link[=xlsx_cutter]{xlsx_cutter()}}
}
\examples{
# Valid template
validate_xltemplate(
  system.file("example", "timesheet_template.xlsx", package = "xlcutter")
)

# Invalid templates
validate_xltemplate(
  system.file("example", "template_duped_vars.xlsx", package = "xlcutter")
)

validate_xltemplate(
  system.file("example", "template_fluff.xlsx", package = "xlcutter"),
  minimal = TRUE
)
}
