#' xlink: A package for genetic association models for X-chromosome SNPS on continuous, binary and survival outcomes.
#'
#' The expression of X-chromosome undergoes three possible biological processes: X-chromosome inactivation (XCI),
#' escape of the X-chromosome inactivation (XCI-E),and skewed X-chromosome inactivation (XCI-S).
#' To analyze the X-linked genetic association for phenotype  such as continuous, binary, and time-to-event outcomes with
#' the actual process unknown, we propose a unified approach of maximizing the likelihood or partial likelihood over
#' all of the potential biological processes.
#'
#'
#' @section xlink functions:
#' xlink_fit, select_output.
#'
#' @docType package
#' @name xlink
#' @references Xu, Wei, and Meiling Hao. 'A unified partial likelihood approach for X-chromosome association on time-to-event outcomes.' Genetic epidemiology 42.1 (2018): 80-94.
NULL
