% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/recrate.R
\name{est.recrate}
\alias{est.recrate}
\title{Estimate recombination rate}
\usage{
est.recrate(genmap, phymap, pos = NULL, window = 5)
}
\arguments{
\item{genmap}{Vector of cM positions of markers, or a list of such vectors.}

\item{phymap}{Vector of Mbp positions of markers, or a list of such vectors;
same length as \code{genmap}.}

\item{pos}{Vector of positions at which the recombination rate should be
estimated, or a list of such vectors.  If NULL, we use the physical
marker positions plus a grid with 4 positions per Mbp.}

\item{window}{Length of sliding window (in Mbp).}
}
\value{
A data.frame containing the positions and estimate recombination
rates.
}
\description{
Obtain a smoothed estimate of the recombination rate along a chromosome,
using the cM and Mbp position of markers.
}
\details{
We assume constant recombination rate within each marker interval.
}
\examples{
# create equally-spaced map
pmap <- sim.map(100, n.mar=51, anchor=TRUE, include.x=FALSE, eq.spacing=TRUE)

# simulate cross
x <- sim.cross(pmap, type="bc", n.ind=501)

# estimate map for that cross
emap <- est.map(x)

# empirical estimate of recombination rate
rr <- est.recrate(emap[[1]], pmap[[1]], window=5)
plot(rr, type="l", lwd=2)

}
\seealso{
\code{\link{est.coi}}, \code{\link{intensity}}
}
\author{
Karl W Broman, \email{kbroman@biostat.wisc.edu}
}
\keyword{models}
