% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strip.R
\name{strip}
\alias{strip}
\title{Strip strings of non-alphanumeric characters}
\usage{
strip(
  strings,
  replacement = "",
  remove_spaces = FALSE,
  remove_numbers = FALSE,
  remove_ansi = TRUE,
  lowercase = FALSE,
  allow_na = TRUE
)
}
\arguments{
\item{strings}{\code{vector} of strings. (Character)}

\item{replacement}{What to replace blocks of punctuation with. (Character)}

\item{remove_spaces}{Whether to remove all whitespaces. (Logical)}

\item{remove_numbers}{Whether to remove all numbers. (Logical)}

\item{remove_ansi}{Whether to remove ANSI control sequences. (Logical)}

\item{lowercase}{Whether to make the strings lowercase. (Logical)}

\item{allow_na}{Whether to allow \code{strings}
to contain \code{NA}s. (Logical)}
}
\value{
The stripped strings.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}
\enumerate{
\item Removes any character that is not alphanumeric or a space.
\item (Disabled by default): Remove numbers.
\item Reduces multiple consecutive whitespaces to a single whitespace and trims ends.
}

Can for instance be used to simplify error messages before checking them.
}
\details{
\enumerate{
\item ANSI control sequences are removed with \code{\link[fansi:strip_ctl]{fansi::strip_ctl()}}.
\item \code{gsub("[^[:alnum:][:blank:]]", replacement, strings))}
\item \code{gsub('[0-9]+', '', strings)} (Note: only if specified!)
\item \code{trimws( gsub("[[:blank:]]+", " ", strings) )}
(Or \code{""} if \code{remove_spaces} is \code{TRUE})
}
}
\examples{
# Attach packages
library(xpectr)

strings <- c(
  "Hello! I am George.  \n\rDon't call me Frank! 123",
  "    \tAs that, is, not, my,     name!"
)

strip(strings)
strip(strings, remove_spaces = TRUE)
strip(strings, remove_numbers = TRUE)
}
\seealso{
Other strippers: 
\code{\link{strip_msg}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{strippers}
