library(xpectr)
context("capture_side_effects()")

# TODO Add a lot more tests here!

test_that("capture_side_effects() works with tibbles", {

  # Tibble uses ansi escape codes to color the "x" in their errors
  # so we've set option(crayon.enable = FALSE) which leaves the x alone.

  df <- tibble::tibble("a" = c(1,2,3),
                       "b" = c("J","K","L"))


  ## Testing 'capture_side_effects(df[[NA]])'                               ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Assigning output
  output_10856 <- capture_side_effects(df[[NA]])
  # Testing class
  expect_equal(
    class(output_10856),
    "list",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_10856,
    type = "list")
  # Testing values
  expect_true(
    strip(output_10856[["error"]]) %in%
    strip(c(
      "Must extract column with a single valid subscript.\nx Subscript `NA` can't be `NA`.",
      "Must extract column with a single valid subscript.\n Subscript `NA` can't be `NA`.",
      "Can't extract column with `NA`.\n✖ Subscript `NA` must be a location, not an integer `NA`."
    )))
  expect_equal(
    output_10856[["error_class"]],
    c("vctrs_error_subscript_type", "vctrs_error_subscript", "rlang_error",
      "error", "condition"),
    fixed = TRUE)
  expect_equal(
    output_10856[["warnings"]],
    NULL)
  expect_equal(
    output_10856[["messages"]],
    NULL)
  expect_equal(
    output_10856[["has_side_effects"]],
    TRUE)
  # Testing names
  expect_equal(
    names(output_10856),
    c("error", "error_class", "warnings", "messages", "has_side_effects"),
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_10856),
    5L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_10856)),
    7L)
  # Testing element classes
  expect_equal(
    xpectr::element_classes(output_10856),
    c("character", "character", "NULL", "NULL", "logical"),
    fixed = TRUE)
  # Testing element types
  expect_equal(
    xpectr::element_types(output_10856),
    c("character", "character", "NULL", "NULL", "logical"),
    fixed = TRUE)
  ## Finished testing 'capture_side_effects(df[[NA]])'                      ####

})


test_that("testing copy_env works in capture_side_effects()", {
  xpectr::set_test_seed(42)

  parent_var <- 3

  f1 <- function(){
    envir <- parent.frame()
    assign(x = "parent_var", value = parent_var + 2, envir = envir)
    message(paste0("A message: ", parent_var))
    warning(paste0("A warning: ", parent_var))
    parent_var
  }

  # Without copy_env

  ## Testing 'f1()'                                                         ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(f1(), reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['warnings']]),
    xpectr::strip("A warning: 9"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['messages']]),
    xpectr::strip("A message: 7\n"),
    fixed = TRUE)
  # Assigning output
  output_19148 <- xpectr::suppress_mw(f1())
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    11,
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    1L)
  ## Finished testing 'f1()'                                                ####


  # With copy_env

  parent_var <- 3

  #gxs_selection("f1()", copy_env = TRUE, indentation = 2)

  ## Testing 'f1()'                                                         ####
  ## Initially generated by xpectr
  xpectr::set_test_seed(42)
  # Testing side effects
  # Assigning side effects
  side_effects_19148 <- xpectr::capture_side_effects(f1(), copy_env = TRUE, reset_seed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['warnings']]),
    xpectr::strip("A warning: 3"),
    fixed = TRUE)
  expect_equal(
    xpectr::strip(side_effects_19148[['messages']]),
    xpectr::strip("A message: 3\n"),
    fixed = TRUE)
  # Assigning output
  output_19148 <- xpectr::suppress_mw(f1())
  # Testing class
  expect_equal(
    class(output_19148),
    "numeric",
    fixed = TRUE)
  # Testing type
  expect_type(
    output_19148,
    type = "double")
  # Testing values
  expect_equal(
    output_19148,
    5,
    tolerance = 1e-4)
  # Testing names
  expect_equal(
    names(output_19148),
    NULL,
    fixed = TRUE)
  # Testing length
  expect_equal(
    length(output_19148),
    1L)
  # Testing sum of element lengths
  expect_equal(
    sum(xpectr::element_lengths(output_19148)),
    1L)
  ## Finished testing 'f1()'                                                ####
  #

})

