% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/length.R
\name{xportr_length}
\alias{xportr_length}
\title{Assign SAS Length}
\usage{
xportr_length(
  .df,
  metacore,
  domain = NULL,
  verbose = getOption("xportr.length_verbose", "none")
)
}
\arguments{
\item{.df}{A data frame of CDISC standard.}

\item{metacore}{A data frame containing variable level metadata.}

\item{domain}{A character value to subset the \code{.df}. If \code{NULL}(default), uses
\code{.df} value as a subset condition.}

\item{verbose}{The action the function takes when a length isn't found in
metadata. Options are 'stop', 'warn', 'message', and 'none'}
}
\value{
Data frame with \code{SASlength} attributes for each variable.
}
\description{
Assigns SAS length from a variable level metadata to a given data frame.
}
\examples{
adsl <- data.frame(
  USUBJID = c(1001, 1002, 1003),
  BRTHDT = c(1, 1, 2)
)

metacore <- data.frame(
  dataset = c("adsl", "adsl"),
  variable = c("USUBJID", "BRTHDT"),
  length = c(10, 8)
)

adsl <- xportr_length(adsl, metacore)
}
\seealso{
\code{\link[=xportr_label]{xportr_label()}}, \code{\link[=xportr_df_label]{xportr_df_label()}} and \code{\link[=xportr_format]{xportr_format()}}

Other metadata functions: 
\code{\link{xportr_df_label}()},
\code{\link{xportr_format}()},
\code{\link{xportr_label}()}
}
\concept{metadata functions}
