% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import.variable.definitions.R
\name{import.variable.definitions}
\alias{import.variable.definitions}
\title{Imports Xpose variable definitions from a file to an Xpose data object.}
\usage{
import.variable.definitions(object, classic = FALSE)
}
\arguments{
\item{object}{An \code{xpose.data} object.}

\item{classic}{A logical operator specifying whether the function should
assume the classic menu system. This is an internal option and need never be
called from the command line.}
}
\value{
An \code{\link{xpose.data}} object (classic == FALSE) or null
(classic == TRUE).
}
\description{
This function imports variable definitions for a specified Xpose data object
from a file.
}
\details{
This function imports variable definitions (contents of object@Prefs@Xvardef)
for a given \code{xpose.data} object from a file, typically
'xpose.vardefs.ini'.  It returns an \code{xpose.data} object. Note that file
format is not the same as used for graphics settings. It is a wrapper for
the R function \code{\link{dget}}.
}
\examples{

\dontrun{
## xpdb5 is an Xpose data object
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb5 <- xpose.data(5)

xpdb5 <- import.variable.definitions(xpdb5)
}

}
\seealso{
\code{\link{export.variable.definitions}},
\code{\link{xpose.prefs-class}} \code{\link{dget}}

Other data functions: \code{\link{add_transformed_columns}},
  \code{\link{change_graphical_parameters}},
  \code{\link{change_misc_parameters}},
  \code{\link{compute.cwres}}, \code{\link{data.checkout}},
  \code{\link{data_extract_or_assign}},
  \code{\link{db.names}}, \code{\link{export.graph.par}},
  \code{\link{export.variable.definitions}},
  \code{\link{import.graph.par}},
  \code{\link{make.sb.data}}, \code{\link{nsim}},
  \code{\link{par_cov_summary}},
  \code{\link{read.TTE.sim.data}},
  \code{\link{read.nm.tables}},
  \code{\link{read_NM_output}},
  \code{\link{read_nm_table}},
  \code{\link{simprazExample}},
  \code{\link{tabulate.parameters}}, \code{\link{xlabel}},
  \code{\link{xpose.data}}, \code{\link{xpose.print}},
  \code{\link{xpose4-package}}, \code{\link{xsubset}}
}
\author{
Niclas Jonsson & Justin Wilkins
}
\keyword{methods}
