% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabulate.parameters.R
\name{tabulate.parameters}
\alias{tabulate.parameters}
\title{Tabulate the population parameter estimates}
\usage{
tabulate.parameters(object, prompt = FALSE, outfile = NULL, dir = "")
}
\arguments{
\item{object}{An xpose.data object.}

\item{prompt}{Ask before printing.}

\item{outfile}{file to output to (NULL means screen).}

\item{dir}{Which directory is the NONMEM output file located. \code{""} means
the current working directory \code{getwd()}.}
}
\value{
A table summarizing the parameters and their precision.
}
\description{
This function provides a summary of the model's parameter estimates and
precision.
}
\examples{

od = setwd(tempdir()) # move to a temp directory
(cur.files <- dir()) # current files in temp directory

simprazExample(overwrite=TRUE) # write files
(new.files <- dir()[!(dir() \%in\% cur.files)])  # what files are new here?
xpdb <- xpose.data(1) # read in files to xpose database

tabulate.parameters(xpdb)

file.remove(new.files) # remove these files
setwd(od)  # restore working directory

}
\seealso{
Other data functions: 
\code{\link{add_transformed_columns}},
\code{\link{change_graphical_parameters}},
\code{\link{change_misc_parameters}},
\code{\link{compute.cwres}()},
\code{\link{data.checkout}()},
\code{\link{data_extract_or_assign}},
\code{\link{db.names}()},
\code{\link{export.graph.par}()},
\code{\link{export.variable.definitions}()},
\code{\link{import.graph.par}()},
\code{\link{import.variable.definitions}()},
\code{\link{make.sb.data}()},
\code{\link{nsim}()},
\code{\link{par_cov_summary}},
\code{\link{read.TTE.sim.data}()},
\code{\link{read.nm.tables}()},
\code{\link{read_NM_output}},
\code{\link{read_nm_table}()},
\code{\link{simprazExample}()},
\code{\link{xlabel}()},
\code{\link{xpose.data}},
\code{\link{xpose.print}()},
\code{\link{xpose4-package}},
\code{\link{xsubset}()}
}
\author{
Niclas Jonsson, Andrew Hooker & Justin Wilkins
}
\concept{data functions}
\keyword{methods}
