% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtdml_main.R
\name{xtdml}
\alias{xtdml}
\title{Abstract class xtdml}
\format{
\link[R6:R6Class]{R6::R6Class} object.
}
\description{
Abstract base class that cannot be initialized.

Implementation of partially linear panel regression (PLPR) models with high-dimensional
confounding variables and exogenous treatment variable within the double machine learning
framework. It allows the estimation of the structural parameter (treatment effect)
in static panel data models with fixed effects using panel data approaches established in
\href{https://academic.oup.com/ectj/advance-article/doi/10.1093/ectj/utaf011/8120202}{Clarke and Polselli (2025)}.
\code{xtdml} is built on the object-oriented \code{DoubleML} (\href{https://www.jstatsoft.org/article/view/v108i03}{Bach et al., 2024})
using the \code{mlr3} ecosystem.
}
\seealso{
Other xtdml: 
\code{\link{xtdml_plr}}
}
\concept{xtdml}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{all_coef_theta}}{(\code{matrix()}) \cr
Estimates of the causal parameter(s) \code{"theta"} for the \code{n_rep} different sample
splits after calling \code{fit()}.}

\item{\code{all_dml1_coef_theta}}{(\code{array()}) \cr
Estimates of the causal parameter(s) \code{"theta"} for the \code{n_rep} different sample
splits after calling \code{fit()} with \code{dml_procedure = "dml1"}.}

\item{\code{all_se_theta}}{(\code{matrix()}) \cr
Standard errors of the causal parameter(s) \code{"theta"} for the \code{n_rep} different
sample splits after calling \code{fit()}.}

\item{\code{all_model_rmse}}{(\code{matrix()}) \cr
Model root-mean-squared-error.}

\item{\code{apply_cross_fitting}}{(\code{logical(1)}) \cr
Indicates whether cross-fitting should be applied. Default is \code{TRUE}.}

\item{\code{coef_theta}}{(\code{numeric()}) \cr
Estimates for the causal parameter(s) \code{"theta"} after calling \code{fit()}.}

\item{\code{data}}{(\code{\link[data.table:data.table]{data.table}})\cr
Data object.}

\item{\code{dml_procedure}}{(\code{character(1)}) \cr
A \code{character()} (\code{"dml1"} or \code{"dml2"}) specifying the double machine
learning algorithm. Default is \code{"dml2"}.}

\item{\code{draw_sample_splitting}}{(\code{logical(1)}) \cr
Indicates whether the sample splitting should be drawn during
initialization of the object. Default is \code{TRUE}.}

\item{\code{learner}}{(named \code{list()}) \cr
The machine learners for the nuisance functions.}

\item{\code{n_folds}}{(\code{integer(1)}) \cr
Number of folds. Default is \code{5}.}

\item{\code{n_rep}}{(\code{integer(1)}) \cr
Number of repetitions for the sample splitting. Default is \code{1}.}

\item{\code{params}}{(named \code{list()}) \cr
The hyperparameters of the learners.}

\item{\code{psi_theta}}{(\code{array()}) \cr
Value of the score function
\eqn{\psi(W;\theta_0,\eta_0)=-\psi_a(W;\eta_0) \theta_0 + \psi_b(W;\eta_0)}
after calling \code{fit()}.}

\item{\code{psi_theta_a}}{(\code{array()}) \cr
Value of the score function component \eqn{\psi_a(W;\eta_0)} after
calling \code{fit()}.}

\item{\code{psi_theta_b}}{(\code{array()}) \cr
Value of the score function component \eqn{\psi_b(W;\eta_0)} after
calling \code{fit()}.}

\item{\code{res_y}}{(\code{array()}) \cr
Residual of output equation}

\item{\code{res_d}}{(\code{array()}) \cr
Residual of treatment equation}

\item{\code{predictions}}{(\code{array()}) \cr
Predictions of the nuisance models after calling
\code{fit(store_predictions=TRUE)}.}

\item{\code{targets}}{(\code{array()}) \cr
Targets of the nuisance models after calling
\code{fit(store_predictions=TRUE)}.}

\item{\code{rmses}}{(\code{array()}) \cr
The root-mean-squared-errors of the nuisance parameters}

\item{\code{all_model_mse}}{(\code{array()}) \cr
Collection of all mean-squared-errors of the model}

\item{\code{model_rmse}}{(\code{array()}) \cr
The root-mean-squared-errors of the model}

\item{\code{models}}{(\code{array()}) \cr
The fitted nuisance models after calling
\code{fit(store_models=TRUE)}.}

\item{\code{pval_theta}}{(\code{numeric()}) \cr
p-values for the causal parameter(s) \code{"theta"} after calling \code{fit()}.}

\item{\code{score}}{(\code{character(1)}) \cr
A \code{character(1)}  specifying the score function among \code{"orth-PO"}, \code{"orth-IV"}.
Default is "\code{orth-PO}".}

\item{\code{se_theta}}{(\code{numeric()}) \cr
Standard errors for the causal parameter(s) \code{"theta"} after calling \code{fit()}.}

\item{\code{smpls}}{(\code{list()}) \cr
The partition used for cross-fitting.}

\item{\code{smpls_cluster}}{(\code{list()}) \cr
The partition used for cross-fitting.
smpl is at cluster-var}

\item{\code{t_stat_theta}}{(\code{numeric()}) \cr
t-statistics for the causal parameter(s)  \code{"theta"} after calling \code{fit()}.}

\item{\code{tuning_res_theta}}{(named \code{list()}) \cr
Results from hyperparameter tuning.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-xtdml-new}{\code{xtdml$new()}}
\item \href{#method-xtdml-print}{\code{xtdml$print()}}
\item \href{#method-xtdml-fit}{\code{xtdml$fit()}}
\item \href{#method-xtdml-split_samples}{\code{xtdml$split_samples()}}
\item \href{#method-xtdml-tune}{\code{xtdml$tune()}}
\item \href{#method-xtdml-summary}{\code{xtdml$summary()}}
\item \href{#method-xtdml-confint}{\code{xtdml$confint()}}
\item \href{#method-xtdml-learner_names}{\code{xtdml$learner_names()}}
\item \href{#method-xtdml-params_names}{\code{xtdml$params_names()}}
\item \href{#method-xtdml-set_ml_nuisance_params}{\code{xtdml$set_ml_nuisance_params()}}
\item \href{#method-xtdml-get_params}{\code{xtdml$get_params()}}
\item \href{#method-xtdml-clone}{\code{xtdml$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-new"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-new}{}}}
\subsection{Method \code{new()}}{
DML with FE is an abstract class that can't be initialized.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$new()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-print"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-print}{}}}
\subsection{Method \code{print()}}{
Print 'DML with FE' objects.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-fit"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-fit}{}}}
\subsection{Method \code{fit()}}{
Estimate DML models with FE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$fit(store_predictions = FALSE, store_models = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{store_predictions}}{(\code{logical(1)}) \cr
Indicates whether the predictions for the nuisance functions should be
stored in field \code{predictions}. Default is \code{FALSE}.}

\item{\code{store_models}}{(\code{logical(1)}) \cr
Indicates whether the fitted models for the nuisance functions should be
stored in field \code{models} if you want to analyze the models or extract
information like variable importance. Default is \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-split_samples"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-split_samples}{}}}
\subsection{Method \code{split_samples()}}{
Draw sample splitting for Double ML models with FE.

The samples are drawn according to the attributes \code{n_folds}, \code{n_rep}
and \code{apply_cross_fitting}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$split_samples()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-tune"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-tune}{}}}
\subsection{Method \code{tune()}}{
Hyperparameter-tuning for DML models with FE.

The hyperparameter-tuning is performed using the tuning methods provided
in the \href{https://mlr3tuning.mlr-org.com/}{mlr3tuning} package. For more
information on tuning in \href{https://mlr3.mlr-org.com/}{mlr3}, we refer to
the section on parameter tuning in the
\href{https://mlr3book.mlr-org.com/chapters/chapter4/hyperparameter_optimization.html}{mlr3 book}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$tune(
  param_set,
  tune_settings = list(n_folds_tune = 5, rsmp_tune = mlr3::rsmp("cv", folds = 5), measure
    = NULL, terminator = mlr3tuning::trm("evals", n_evals = 20), algorithm =
    mlr3tuning::tnr("grid_search"), resolution = 5),
  tune_on_folds = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{param_set}}{(named \code{list()}) \cr
A named \code{list} with a parameter grid for each nuisance model/learner
(see method \code{learner_names()}). The parameter grid must be an object of
class \link[paradox:ParamSet]{ParamSet}.}

\item{\code{tune_settings}}{(named \code{list()}) \cr
A named \code{list()} with arguments passed to the hyperparameter-tuning with
\href{https://mlr3tuning.mlr-org.com/}{mlr3tuning} to set up
\link[mlr3tuning:TuningInstanceSingleCrit]{TuningInstance} objects.
\code{tune_settings} has entries
\itemize{
\item \code{terminator} (\link[bbotk:Terminator]{Terminator}) \cr
A \link[bbotk:Terminator]{Terminator} object. Specification of \code{terminator}
is required to perform tuning.
\item \code{algorithm} (\link[mlr3tuning:Tuner]{Tuner} or \code{character(1)}) \cr
A \link[mlr3tuning:Tuner]{Tuner} object (recommended) or key passed to the
respective dictionary to specify the tuning algorithm used in
\link[mlr3tuning:tnr]{tnr()}. \code{algorithm} is passed as an argument to
\link[mlr3tuning:tnr]{tnr()}. If \code{algorithm} is not specified by the users,
default is set to \code{"grid_search"}. If set to \code{"grid_search"}, then
additional argument \code{"resolution"} is required.
\item \code{rsmp_tune} (\link[mlr3:Resampling]{Resampling} or \code{character(1)})\cr
A \link[mlr3:Resampling]{Resampling} object (recommended) or option passed
to \link[mlr3:mlr_sugar]{rsmp()} to initialize a
\link[mlr3:Resampling]{Resampling} for parameter tuning in \code{mlr3}.
If not specified by the user, default is set to \code{"cv"}
(cross-validation).
\item \code{n_folds_tune} (\code{integer(1)}, optional) \cr
If \code{rsmp_tune = "cv"}, number of folds used for cross-validation.
If not specified by the user, default is set to \code{5}.
\item \code{measure} (\code{NULL}, named \code{list()}, optional) \cr
Named list containing the measures used for parameter tuning. Entries in
list must either be \link[mlr3:Measure]{Measure} objects or keys to be
passed to passed to \link[mlr3:mlr_sugar]{msr()}. The names of the entries must
match the learner names (see method \code{learner_names()}). If set to \code{NULL},
default measures are used, i.e., \code{"regr.mse"} for continuous outcome
variables and \code{"classif.ce"} for binary outcomes.
\item \code{resolution} (\code{character(1)}) \cr The key passed to the respective
dictionary to specify  the tuning algorithm used in
\link[mlr3tuning:tnr]{tnr()}. \code{resolution} is passed as an argument to
\link[mlr3tuning:tnr]{tnr()}.
}}

\item{\code{tune_on_folds}}{(\code{logical(1)}) \cr
Indicates whether the tuning should be done fold-specific or globally.
Default is \code{FALSE}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-summary"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-summary}{}}}
\subsection{Method \code{summary()}}{
Summary for DML models with FE after calling \code{fit()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$summary(digits = max(3L, getOption("digits") - 3L))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{digits}}{(\code{integer(1)}) \cr
The number of significant digits to use when printing.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-confint"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-confint}{}}}
\subsection{Method \code{confint()}}{
Confidence intervals for DML models with FE.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$confint(parm, joint = FALSE, level = 0.95)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parm}}{(\code{numeric()} or \code{character()}) \cr
A specification of which parameters are to be given confidence intervals
among the variables for which inference was done, either a vector of
numbers or a vector of names. If missing, all parameters are considered
(default).}

\item{\code{joint}}{(\code{logical(1)}) \cr
Indicates whether joint confidence intervals are computed.
Default is \code{FALSE}.}

\item{\code{level}}{(\code{numeric(1)}) \cr
The confidence level. Default is \code{0.95}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{matrix()} with the confidence interval(s).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-learner_names"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-learner_names}{}}}
\subsection{Method \code{learner_names()}}{
Returns the names of the learners.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$learner_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character()} with names of learners.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-params_names"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-params_names}{}}}
\subsection{Method \code{params_names()}}{
Returns the names of the nuisance models with hyperparameters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$params_names()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
\code{character()} with names of nuisance models with hyperparameters.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-set_ml_nuisance_params"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-set_ml_nuisance_params}{}}}
\subsection{Method \code{set_ml_nuisance_params()}}{
Set hyperparameters for the nuisance models of DML models with FE.

Note that in the current implementation, either all parameters have to
be set globally or all parameters have to be provided fold-specific.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$set_ml_nuisance_params(
  learner = NULL,
  treat_var = NULL,
  params,
  set_fold_specific = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{(\code{character(1)}) \cr
The nuisance model/learner (see method \code{params_names}).}

\item{\code{treat_var}}{(\code{character(1)}) \cr
The treatment variAble (hyperparameters can be set treatment-variable
specific).}

\item{\code{params}}{(named \code{list()}) \cr
A named \code{list()} with estimator parameters for time-varying covariates. Parameters are used for all
folds by default. Alternatively, parameters can be passed in a
fold-specific way if option  \code{fold_specific}is \code{TRUE}. In this case, the
outer list needs to be of length \code{n_rep} and the inner list of length
\code{n_folds_per_cluster}.}

\item{\code{set_fold_specific}}{(\code{logical(1)}) \cr
Indicates if the parameters passed in \code{params} should be passed in
fold-specific way. Default is \code{FALSE}. If \code{TRUE}, the outer list needs
to be of length \code{n_rep} and the inner list of length \code{n_folds_per_cluster}.
Note that in the current implementation, either all parameters have to
be set globally or all parameters have to be provided fold-specific.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-get_params"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-get_params}{}}}
\subsection{Method \code{get_params()}}{
Get hyper-parameters for the nuisance model of xtdml models.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$get_params(learner)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{learner}}{(\code{character(1)}) \cr
The nuisance model/learner (see method \code{params_names()})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
named \code{list()}with paramers for the nuisance model/learner.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-xtdml-clone"></a>}}
\if{latex}{\out{\hypertarget{method-xtdml-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{xtdml$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
