% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{addEventLines}
\alias{addEventLines}
\title{Add vertical lines to an existing xts plot}
\usage{
addEventLines(events, main = "", on = 0, lty = 1, lwd = 1, col = 1, ...)
}
\arguments{
\item{events}{An xts object of events and their associated labels. It is
ensured that the first column of \code{events} is the event description/label.}

\item{main}{Main title for a new panel, if drawn.}

\item{on}{Panel number to draw on. A new panel will be drawn if \code{on = NA}.
The default, \code{on = 0}, will add to the active panel. The active panel is
defined as the panel on which the most recent action was performed. Note
that only the first element of \code{on} is checked for the default behavior to
add to the last active panel.}

\item{lty}{Set the line type, same as in \code{\link[=par]{par()}}.}

\item{lwd}{Set the line width, same as in \code{\link[=par]{par()}}.}

\item{col}{Color palette to use, set by default to rational choices.}

\item{\dots}{Any other passthrough parameters to \code{\link[=text]{text()}} to control how
the event labels are drawn.}
}
\description{
Add vertical lines and labels to an existing xts plot.
}
\examples{

\dontrun{
library(xts)
data(sample_matrix)
sample.xts <- as.xts(sample_matrix)
events <- xts(letters[1:3], 
              as.Date(c("2007-01-12", "2007-04-22", "2007-06-13")))
plot(sample.xts[,4])
addEventLines(events, srt = 90, pos = 2)
}

}
\author{
Ross Bennett
}
