% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/commons.R
\name{irt}
\alias{gen.rsp}
\alias{irt}
\alias{plot.irt}
\title{IRT Object}
\usage{
irt(theta, a, b, c, rsp = NULL)

gen.rsp(x)

\method{plot}{irt}(x, ...)
}
\arguments{
\item{theta}{a vector of ability parameters}

\item{a}{a vector/number of a parameters (item discrimination)}

\item{b}{a vector of b parameters (item difficulty)}

\item{c}{a vector/number of c parameters (item pseudo-guesing)}

\item{rsp}{a response matrix (optional)}

\item{x}{an IRT object}

\item{...}{other arguments, e.g., type, total, items}
}
\value{
\code{irt} an \code{irt} object

\code{plot} returns a ggplot2 object
}
\description{
\code{irt} creates an IRT object with given values

\code{gen.rsp} generates binary/dichotomous responses for a given IRT object

\code{plot} plots probability/information fuctions for items in an IRT object
}
\details{
An \code{irt} object contains thetas and item parameters as well as an optional repsonse matrix. 
D=1.7 by default. set a=.588 for Rasch items.
}
\examples{
# create an IRT object without responses
irt(rnorm(10), a=c(.8, 1.0, 1.2), b=c(-.5, 0, .5), c=0)
# create an IRT object with responses
irt(rnorm(10), a=1, b=rnorm(5), c=0, rsp=matrix(round(runif(50)),nrow=10,ncol=5))
# generate responses
gen.rsp(gen.irt(10, 5))
# plot TCC
plot(gen.irt(10, 5))
# plot ICCs
plot(gen.irt(10, 5), total=FALSE) 
# plot TIF
plot(gen.irt(10, 5), type="information") 
# plot IIFs
plot(gen.irt(10, 5), type="information", total=FALSE)
}
\seealso{
Other commons: \code{\link{gen.irt}}, \code{\link{prob}}

Other commons: \code{\link{gen.irt}}, \code{\link{prob}}

Other commons: \code{\link{gen.irt}}, \code{\link{prob}}
}

