% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module0_helpers.R, R/module0_utils.R,
%   R/module1_model_3pl.R, R/module1_model_gpcm.R, R/module3_ata.R,
%   R/module5_mst.R
\name{helpers}
\alias{helpers}
\alias{hermite_gauss}
\alias{model_3pl_dv_t}
\alias{model_3pl_dv_a}
\alias{model_3pl_dv_b}
\alias{model_3pl_dv_c}
\alias{model_3pl_estimate_inits}
\alias{model_3pl_estimate_nr}
\alias{model_3pl_posterior_dist}
\alias{evaluate_3pl_estimation}
\alias{model_gpcm_onehot_response}
\alias{model_gpcm_extract_3Ddata}
\alias{model_gpcm_dv_t}
\alias{model_gpcm_dv_a}
\alias{model_gpcm_dv_b}
\alias{model_gpcm_estimate_inits}
\alias{model_gpcm_estimate_nr}
\alias{evaluate_gpcm_estimation}
\alias{ata_append_constraints}
\alias{ata_form_index}
\alias{ata_obj_coef}
\alias{ata_solve_lpsolve}
\alias{ata_solve_glpk}
\alias{mst_get_indices}
\title{Helpers}
\usage{
hermite_gauss(num_quad = 20)

model_3pl_dv_t(u, t, a, b, c, D, prior = NULL)

model_3pl_dv_a(u, t, a, b, c, D, prior = NULL, post_prob = NULL)

model_3pl_dv_b(u, t, a, b, c, D, prior = NULL, post_prob = NULL)

model_3pl_dv_c(u, t, a, b, c, D, prior = NULL, post_prob = NULL)

model_3pl_estimate_inits(u, t, a, b, c)

model_3pl_estimate_nr(param, h, is_free, h_max, bounds)

model_3pl_posterior_dist(u, a, b, c, D, quad_t, quad_w)

evaluate_3pl_estimation(data_tru, data_est)

model_gpcm_onehot_response(u, num_category = NULL)

model_gpcm_extract_3Ddata(data, u)

model_gpcm_dv_t(u, t, a, b, D, prior = NULL)

model_gpcm_dv_a(u, t, a, b, D, prior = NULL, post_prob = NULL)

model_gpcm_dv_b(u, t, a, b, D, prior = NULL, post_prob = NULL)

model_gpcm_estimate_inits(u, t, a, b, d, set_initial)

model_gpcm_estimate_nr(param, h, is_free, h_max, bounds)

evaluate_gpcm_estimation(data_tru, data_est)

ata_append_constraints(x, mat, dir, rhs)

ata_form_index(x, forms, collapse, internal_index)

ata_obj_coef(x, coef, compensate)

ata_solve_lpsolve(x, time_limit, message, ...)

ata_solve_glpk(x, time_limit, message, ...)

mst_get_indices(x, indices)
}
\arguments{
\item{num_quad}{the number of quadrature points}

\item{prior}{parameters of the prior distribution}

\item{post_prob}{posterior distribution of the theta}

\item{param}{the parameters to be updated}

\item{h}{change of parameters in the newton-raphson method}

\item{is_free}{TRUE to estimate parameters and FALSE to fix parameters}

\item{quad_t}{values of quadrature points}

\item{quad_w}{weights of quadrature points}

\item{data_tru}{a list of true parameters}

\item{data_est}{a list of estimated parameters}

\item{data}{the 3-dimensional data}

\item{mat}{the coefficient matrix}

\item{dir}{direction}

\item{rhs}{right-hand-side value}

\item{compensate}{\code{TRUE} to combine coefficients}

\item{prior}{parameters of the prior distribution}

\item{post_prob}{posterior distribution of the theta}

\item{h}{change of parameters in the newton-raphson method}

\item{is_free}{TRUE to estimate parameters and FALSE to fix parameters}
}
\description{
Helpers

\code{evaluate_3pl_estimation} evaluates estimation results against true values

\code{model_gpcm_onehot_response} converts 2-dimensional score
matrix to a 3-dimensional one-hot vector of score category

\code{evaluate_gpcm_estimation} evaluates estimation results against true values

\code{ata_append_constraints} appends constraint definitions to the ata object

\code{ata_form_index} converts input forms into actual form indices in the LP model

\code{ata_obj_coef} processes input coefficients of the objective functions

\code{ata_solve_lpsolve} solves the the LP model using lp_solve

\code{ata_solve_glpk} solves the the LP model using GLPK

\code{mst_get_indices} maps the input indices to the actual indices
}
\keyword{internal}
