% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/x_index.R
\name{x_index}
\alias{x_index}
\title{x_index}
\usage{
x_index(df, kw, id, cit, dlm = ";")
}
\arguments{
\item{df}{A data frame object containing bibliometric data}

\item{kw}{Column in df containing keywords}

\item{id}{Column in df containing IDs}

\item{cit}{Column in df containing citations}

\item{dlm}{Delimiter in kw. Default set to ";"}
}
\value{
x-index value for institution
}
\description{
Compute x-index for an institution from an edge list
}
\examples{
dat1 <- data.frame(citations = c(0, 1, 1, 2, 3, 5, 8),
                   keywords = c("a; b; c", "b; d", "c", "d", "e; g", "f", "g"),
                   id = c("abc123", "bcd234", "def345", "efg456", "fgh567", "ghi678", "hij789"),
                   categories = c("a; d; e", "b", "c", "d; g", "e", "f", "g"))
x_index(df = dat1, kw = "keywords", id = "id", cit = "citations", dlm = ";")

dat2 <- data.frame(citations = c(0, 1, 1, 2, 3, 5, 8),
                  keywords = c("a/ b/ c", "b/ d", "c", "d", "e/ g", "f", "g"),
                  id = c("123", "234", "345", "456", "567", "678", "789"),
                  categories = c("a/ d/ e", "b", "c", "d/ g", "e", "f", "g"))
x_index(df = dat2, kw = "keywords", id = "id", cit = "citations", dlm = "/")

dat3 <- data.frame(citations = c(0, 1, 1, 2, 3, 5, 8),
                  keywords = c("a, b, c", "b, d", "c", "d", "e, g", "f", "g"),
                  id = c(123, 234, 345, 456, 567, 678, 789),
                  categories = c("a: d: e", "b", "c", "d: g", "e", "f", "g"))
x_index(df = dat3, kw = "keywords", id = "id", cit = "citations", dlm = ",")
}
