% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cryptic_transcripts_methods.R
\name{enrichment_score}
\alias{enrichment_score}
\title{3' enrichment score}
\usage{
enrichment_score(geneCoverage)
}
\arguments{
\item{geneCoverage}{object of type geneCoverage containing the
coverage values for all samples.}
}
\value{
An object of class 'CrypticScore' with the following components:
      \item{geneAnnotation}{An object of class \code{\link{annotationsSet}}
                             containing the information on the gene.}
       \item{crypticScore}{Cryptic score obtained by comparing
                           type2 data to type1 data}
       \item{controls}{A list containing the scores obtained by
                       comparing replicates of each type of data}
       \item{method}{The method used.}
}
\description{
Calculates the cryptic score (3' enrichment score) using the 3'/5' ratio method as described in DeGennaro et al., 2013.
}
\examples{
data(yer109c)
enrichment_score (yer109c)

}

