% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coverageDataSet.R
\name{gene_coverage}
\alias{gene_coverage}
\title{Compute coverage data for a specific gene.}
\usage{
gene_coverage(coverageDataSet, name, introns = NULL)
}
\arguments{
\item{coverageDataSet}{an objet of type \code{\link{coverageDataSet}}
containing the coverage values for each sample.}

\item{name}{a character vector indicating the gene name.}

\item{introns}{an objet of type \code{\link{annotationsSet}}
containing the annotations of the intronic regions.
Note: The introns must have same name as the gene they
are associated with.}
}
\value{
An objet of type geneCoverage containing the coverage values
        for the specified \code{gene} for all the samples in \code{coverageDataSet}.
}
\description{
This function computes data for a specific gene and remove intronic regions.
}
\examples{
data(rna_seq_signals)
data(introns)
gene_coverage(rna_seq_signals, "YER109C", introns)
}

