% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cryptic_transcripts_methods.R
\name{ratio_score}
\alias{ratio_score}
\title{3'/5' ratio score}
\usage{
ratio_score(geneCoverage, windowLength = 100)
}
\arguments{
\item{geneCoverage}{object of type geneCoverage containing the
coverage values for all samples.}

\item{windowLength}{A integer indicating the length of the window to use at each end of the gene.}
}
\value{
An object of class 'CrypticScore' with the following components:
      \item{geneAnnotation}{An object of class \code{\link{annotationsSet}}
                             containing the information on the gene.}
       \item{crypticScore}{Cryptic score obtained by comparing
                           type2 data to type1 data}
       \item{controls}{A list containing the scores obtained by
                       comparing replicates of each type of data}
       \item{method}{The method used.}
}
\description{
Calculates the cryptic score (ratio score) using
the 3'/5' ratio method as described in Cheung et al., 2008.
}
\examples{
data(yer109c)
ratio_score(yer109c)

}

