% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sub_units.R
\name{sub_units}
\alias{sub_units}
\title{Place Units Under Label}
\usage{
sub_units(
  x,
  ...,
  open = if (style == "plain") "\\n(" else "\\\\n(",
  close = ")",
  style = "latex",
  math_open = "",
  math_close = "",
  label_open = "$\\\\begin{gathered}",
  label_close = "\\\\end{gathered}$",
  newline = "\\\\\\\\"
)
}
\arguments{
\item{x}{object}

\item{...}{passed to \code{\link{append_units}}}

\item{open}{character to precede units}

\item{close}{character to follow units}

\item{style}{one of 'plain', 'latex', or 'plotmath'}

\item{math_open, math_close, label_open, label_close, newline}{passed to \code{\link{as_latex.spar}} if style = 'latex'}
}
\value{
see methods for append_units
}
\description{
Places units attribute below label attribute.
Makes the most sense for figures (\code{style = 'plotmath'})
and useful for tables (\code{style = 'latex'}) in combination
with \code{\link{alias}}. See also \code{\link{append_units}}.
}
\examples{
library(units)
library(magrittr)
library(dplyr)
library(ggplot2)
x <- 1:10
attr(x, 'label') <- 'acceleration'
units(x) <- 'm/s^2'
y <- as_units('kg')
x \%>\% attr('label')
x \%>\% sub_units \%>\% attr('label')
x \%>\% sub_units(style = 'plotmath') \%>\% attr('label')
x \%>\% sub_units(style = 'plain') \%>\% attr('label') \%>\% writeLines
y \%>\% attr('label')
y \%>\% sub_units(style = 'plain') \%>\% attr('label')
x \%>\% sub_units(style = 'plotmath')
x \%>\% sub_units(style = 'latex')

file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
file \%>\% decorate \%>\% resolve \%>\%
sub_units(style = 'plotmath') \%>\%
ggplot(data = ., aes(x = time, y = conc, color = Heart)) \%>\%
add(geom_point())
}
\seealso{
Other labels: 
\code{\link{alias.data.frame}()},
\code{\link{append_units.data.frame}()},
\code{\link{append_units.default}()},
\code{\link{append_units}()}
}
\concept{labels}
\keyword{internal}
