% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{read_yamlet}
\alias{read_yamlet}
\title{Read Yamlet}
\usage{
read_yamlet(
  x,
  ...,
  default_keys = getOption("yamlet_default_keys", list("label", "guide"))
)
}
\arguments{
\item{x}{file path for yamlet, or vector of yamlet in storage syntax}

\item{...}{passed to \code{\link{as_yamlet}}}

\item{default_keys}{character: default keys for the first n anonymous members of each element}
}
\value{
yamlet: a named list with default keys applied
}
\description{
Reads yamlet from file.
Similar to \code{\link{io_yamlet.character}}
but also reads text fragments.
}
\examples{
library(csv)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
meta <- system.file(package = 'yamlet', 'extdata','quinidine.yaml')
x <- as.csv(file)
y <- read_yamlet(meta)
x <- decorate(x, meta = y)
identical(x, decorate(file))
}
\seealso{
\code{\link{decorate.data.frame}}

Other interface: 
\code{\link{as.data.frame.yamlet}()},
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()},
\code{\link{write_yamlet}()}
}
\concept{interface}
