% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{write_yamlet}
\alias{write_yamlet}
\title{Write Yamlet}
\usage{
write_yamlet(
  x,
  con = stdout(),
  eol = "\\n",
  useBytes = FALSE,
  default_keys = getOption("yamlet_default_keys", list("label", "guide")),
  fileEncoding = getOption("encoding"),
  block = FALSE,
  ...
)
}
\arguments{
\item{x}{something that can be coerced to class 'yamlet', like a yamlet object or a decorated data.frame}

\item{con}{passed to \code{\link{writeLines}}}

\item{eol}{end-of-line; passed to \code{\link{writeLines}} as \code{sep}}

\item{useBytes}{passed to \code{\link{writeLines}}}

\item{default_keys}{character: default keys for the first n anonymous members of each element}

\item{fileEncoding}{if \code{con} is character, passed to \code{\link{file}} as \code{encoding}}

\item{block}{whether to write block scalars}

\item{...}{passed to \code{\link{as_yamlet}} and to \code{\link{as.character.yamlet}}}
}
\value{
invisible character representation of yamlet (storage syntax)
}
\description{
Writes yamlet to file. Similar to \code{\link{io_yamlet.yamlet}}
but returns invisible storage format instead of invisible storage location.
}
\examples{
library(csv)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
meta <- system.file(package = 'yamlet', 'extdata','quinidine.yaml')
x <- as.csv(file)
y <- read_yamlet(meta)
x <- decorate(x, meta = y)
identical(x, decorate(file))
tmp <- tempfile()
write_yamlet(x, tmp)
stopifnot(identical(read_yamlet(meta), read_yamlet(tmp)))
}
\seealso{
\code{\link{decorate.list}}

Other interface: 
\code{\link{canonical.decorated}()},
\code{\link{classified.data.frame}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{desolve.decorated}()},
\code{\link{ggplot.decorated}()},
\code{\link{io_csv.character}()},
\code{\link{io_csv.data.frame}()},
\code{\link{io_res.character}()},
\code{\link{io_res.decorated}()},
\code{\link{io_table.character}()},
\code{\link{io_table.data.frame}()},
\code{\link{io_yamlet.character}()},
\code{\link{io_yamlet.data.frame}()},
\code{\link{is_parseable.default}()},
\code{\link{mimic.default}()},
\code{\link{modify.default}()},
\code{\link{promote.list}()},
\code{\link{read_yamlet}()},
\code{\link{resolve.decorated}()},
\code{\link{selected.default}()}
}
\concept{interface}
