% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alias.R
\name{alias.data.frame}
\alias{alias.data.frame}
\title{Alias a Data Frame}
\usage{
\method{alias}{data.frame}(object, ...)
}
\arguments{
\item{object}{data.frame}

\item{...}{optional unquoted names of target columns}
}
\value{
aliased data.frame
}
\description{
Aliases a data.frame.
Replaces column names with labels, where present.
Stores column name as 'alias' attribute.
}
\examples{
library(magrittr)
d <- data.frame(x = 1:10, y = 1:10, z = 1:10)
d \%<>\% modify(x, label = 'Independent Value')
d \%<>\% modify(y, label = 'Dependent Value')
d
alias(d)
alias(d, y)
}
\seealso{
Other labels: 
\code{\link{append_units}()},
\code{\link{append_units.data.frame}()},
\code{\link{append_units.default}()},
\code{\link{drop_title}()},
\code{\link{drop_title.decorated}()},
\code{\link{drop_title.default}()},
\code{\link{drop_title.dvec}()},
\code{\link{make_title}()},
\code{\link{make_title.decorated}()},
\code{\link{make_title.default}()},
\code{\link{make_title.dvec}()},
\code{\link{sub_units}()}

Other deprecated: 
\code{\link{append_units}()},
\code{\link{drop_title}()},
\code{\link{make_title}()}
}
\concept{deprecated}
\concept{labels}
\keyword{internal}
