% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignBurstSeq.R
\name{alignBurstSeq}
\alias{alignBurstSeq}
\title{Align synced data with known burst sequence}
\usage{
alignBurstSeq(
  synced_dat,
  burst_seq,
  seq_lng_min = 10,
  rbi_min,
  rbi_max,
  plot_diag = TRUE
)
}
\arguments{
\item{synced_dat}{data.table obtained using applySync() on a detections_table}

\item{burst_seq}{Vector containing known burst sequence}

\item{seq_lng_min}{Minimum length of sequence of consecutive pings to use for the alignment. Finds first occurence of sequence of this length in the data and compare to the known burst sequence}

\item{rbi_min, rbi_max}{Minimum and maximum burst interval of the transmitter. Used to identify sequence of consecutive pings in the data}

\item{plot_diag}{Logical indicating if visual diagnosis plots should be created.}
}
\value{
\code{data.table} like the input \code{synced_dat}, but with extra columns seq_ping_idx and seq_epo
}
\description{
Identifies where in the sequence of known burst intervals the detected data is from.
Add extra columns to data.table containing ping index of the burst sequence (seq_ping_idx) and expected time of ping (seq_epo).
Only to be used for 'random' burst interval data when you know the burst sequence.
}
\examples{
# Align data from a tag with known random burst interval to the burst interval sequence
# using the hald data included in `yapsdata` (see ?yapsdata::hald for info).
synced_dat_1315 <- dat_align$synced_dat_1315
seq_1315 <- dat_align$seq_1315
rbi_min <- 60
rbi_max <- 120
aligned_dat <- alignBurstSeq(synced_dat=synced_dat_1315, burst_seq=seq_1315, 
	rbi_min=rbi_min, rbi_max=rbi_max, plot_diag=TRUE)
}
