% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tempToSs.R
\name{tempToSs}
\alias{tempToSs}
\title{Calculate speed of sound from water temperature, salinity and depth
Based on H. Medwin (1975) Speed of sound in water: A simple equation for realistic parameters. (https://doi.org/10.1121/1.380790)}
\usage{
tempToSs(temp, sal, depth = 5)
}
\arguments{
\item{temp}{Water temperature in degrees Celcius}

\item{sal}{Water slinity in parts per thousand (promille)}

\item{depth}{Depth in meters - default = 5 m - can typically be ignored}
}
\value{
Vector of estimated speed of sound in water.
}
\description{
Calculate speed of sound from water temperature, salinity and depth
Based on H. Medwin (1975) Speed of sound in water: A simple equation for realistic parameters. (https://doi.org/10.1121/1.380790)
}
\examples{
water_temp <- rnorm(100, 20, 2)
ss <- tempToSs(temp=water_temp, sal=0, depth=5)
}
