% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/surv-roc_auc_survival.R
\name{roc_auc_survival}
\alias{roc_auc_survival}
\alias{roc_auc_survival.data.frame}
\alias{roc_auc_survival_vec}
\title{Time-Dependent ROC AUC for Censored Data}
\usage{
roc_auc_survival(data, ...)

\method{roc_auc_survival}{data.frame}(data, truth, ..., na_rm = TRUE, case_weights = NULL)

roc_auc_survival_vec(truth, estimate, na_rm = TRUE, case_weights = NULL, ...)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by \code{truth} and
\code{...}.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true survival result (that
is created using \code{\link[survival:Surv]{survival::Surv()}}.). This should be an unquoted column name
although this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column names). For
\verb{_vec()} functions, an \code{\link[survival:Surv]{survival::Surv()}} object.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights.
This should be an unquoted column name that evaluates to a numeric column
in \code{data}. For \verb{_vec()} functions, a numeric vector.}

\item{estimate}{If \code{truth} is binary, a numeric vector of class probabilities
corresponding to the "relevant" class. Otherwise, a matrix with as many
columns as factor levels of \code{truth}. \emph{It is assumed that these are in the
same order as the levels of \code{truth}.}}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator}, and \code{.estimate}.

For an ungrouped data frame, the result has one row of values. For a grouped data frame,
the number of rows returned is the same as the number of groups.

For \code{roc_auc_survival_vec()}, a \code{numeric} vector same length as the input argument
\code{eval_time}. (or \code{NA}).
}
\description{
Compute the area under the ROC survival curve using predicted survival
probabilities that corresponds to different time points.
}
\details{
This formulation takes survival probability predictions at one or more
specific \emph{evaluation times} and, for each time, computes the area under the
ROC curve. To account for censoring, inverse probability of censoring weights
(IPCW) are used in the calculations. See equation 7 of section 4.3 in
Blanche \emph{at al} (2013) for the details.

The column passed to \code{...} should be a list column with one element per
independent experiential unit (e.g. patient). The list column should contain
data frames with several columns:
\itemize{
\item \code{.eval_time}: The time that the prediction is made.
\item \code{.pred_survival}: The predicted probability of survival up to \code{.eval_time}
\item \code{.weight_censored}: The case weight for the inverse probability of censoring.
}

The last column can be produced using \code{\link[parsnip:censoring_weights]{parsnip::.censoring_weights_graf()}}.
This corresponds to the weighting scheme of  Graf \emph{et al} (1999). The
internal data set \code{lung_surv} shows an example of the format.

This method automatically groups by the \code{.eval_time} argument.

Smaller values of the score are associated with better model performance.
}
\examples{
library(dplyr)

lung_surv \%>\%
  roc_auc_survival(
    truth = surv_obj,
    .pred
  )
}
\references{
Blanche, P., Dartigues, J.-F. and Jacqmin-Gadda, H. (2013), Review and
comparison of ROC curve estimators for a time-dependent outcome with
marker-dependent censoring. \emph{Biom. J.}, 55: 687-704.

Graf, E., Schmoor, C., Sauerbrei, W. and Schumacher, M. (1999), Assessment
and comparison of prognostic classification schemes for survival data.
\emph{Statist. Med.}, 18: 2529-2545.
}
\seealso{
Compute the ROC survival curve with \code{\link[=roc_curve_survival]{roc_curve_survival()}}.

Other dynamic survival metrics: 
\code{\link{brier_survival_integrated}()},
\code{\link{brier_survival}()}
}
\author{
Emil Hvitfeldt
}
\concept{dynamic survival metrics}
\keyword{internal}
