% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sentence.R
\name{sentence}
\alias{sentence}
\title{sentence}
\usage{
sentence(...)
}
\arguments{
\item{...}{passed on to \code{paste}}
}
\description{
A wrapper around \code{paste} that does some simple cleaning appropriate for
prose sentences. It
\enumerate{
   \item trims leading and trailing whitespace
   \item collapses runs of whitespace into a single space
   \item appends a period (\code{.}) if there is no terminal punctuation
         mark (\code{.}, \code{?}, or \code{!})
   \item removes spaces preceding punctuation characters: \code{.?!,;:}
   \item collapses sequences of punctuation marks (\code{.?!,;:}) (possibly
         separated by spaces), into a single punctuation mark.
         The first punctuation mark of the sequence is used, with
         priority given to terminal punctuation marks \code{.?!} if present
   \item makes sure a space or end-of-string follows every one of
         \code{.?!,;:}, with an exception for the special case of \code{.,:}
         followed by a digit, indicating the punctuation is decimal period,
         number separator, or time delimiter
   \item capitalizes the first letter of each sentence (start-of-string or
         following a \code{.?!})
}
}
\examples{
compare <- function(x) cat(sprintf(' in: "\%s"\\nout: "\%s"\\n', x, sentence(x)))
compare("capitilized and period added")
compare("whitespace:added ,or removed ; like this.and this")
compare("periods and commas in numbers like 1,234.567 are fine !")
compare("colons can be punctuation or time : 12:00 !")
compare("only one punctuation mark at a time!.?,;")
compare("The first mark ,; is kept;,,with priority for terminal marks ;,.")

# vectorized like paste()
sentence(
 "The", c("first", "second", "third"), "letter is", letters[1:3],
 parens("uppercase:", sngl_quote(LETTERS[1:3])), ".")
}
