% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/markdownr.R
\name{code_chunk}
\alias{code_chunk}
\alias{setup_chunk}
\title{Write code chunks programmatically}
\usage{
code_chunk(chunk_code, chunk_name = NULL, chunk_args = NULL)

setup_chunk(chunk_code = NULL, chunk_args = list(include = FALSE))
}
\arguments{
\item{chunk_code}{An expression. Surround with \code{{}} to capture multiple
lines.}

\item{chunk_name}{The name of the chunk}

\item{chunk_args}{A \code{list} of chunk options}
}
\value{
a character vector
}
\description{
\code{code_chunk()} assembles a knitr code chunk as a character vector.
\code{setup_chunk()} is a wrapper around \code{code_chunk()} to create setup chunks. By
default it uses \code{include = FALSE} and inserts \code{knitr::opts_chunk$set(echo = TRUE)} into the chunk body. These are helper functions to write R Markdown
bodies for \code{\link[=use_rmarkdown]{use_rmarkdown()}}.
}
\examples{
\donttest{
setup_chunk()

code_chunk({
  yml() \%>\%
    yml_output(pdf_document())
}, chunk_name = "yml_example")
}
}
