% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/card.R
\name{card}
\alias{card}
\alias{deck}
\title{Cards, blocks of content}
\usage{
card(..., header = NULL, footer = NULL)

deck(...)
}
\arguments{
\item{...}{For \strong{card}, \code{tag$div()}s, tag elements, or list groups to
include in the card or additional named arguments passed as HTML attributes
to the parent element.

For \strong{deck}, any number of \code{card()}s or additional named arguments passed
as HTML attributes to the parent element.}

\item{header}{A character string or tag element specifying the header of the
card, defaults to \code{NULL}, in which case a header is not added.}

\item{footer}{A character string or tag element specifying the footer of the
card, defaults to \code{NULL}, in which case a footer is not added.}
}
\description{
Create blocks of content with \code{card}. \code{deck} is used to group and add padding
is placed around any number of cards. Additionally, grouping cards with
\code{deck} has the benefit of aligning the footer of each card.
}
\examples{

### A simple card

column(
  width = 4,
  card(
    p("Praesent fermentum tempor tellus.")
  )
)

### Adding a title, subtitle

column(
  width = 4,
  card(
    h5("Mauris mollis tincidunt felis."),
    h6("Phasellus at dui in ligula mollis ultricies."),
    p("Nullam tempus. Mauris mollis tincidunt felis."),
    p("Nullam libero mauris, consequat quis, varius et, dictum id, arcu.")
  )
)

### Styling cards

deck(
  card(
    header = "Donec pretium posuere tellus",
    p("Donec hendrerit tempor tellus."),
    p("Cras placerat accumsan nulla.")
  ) \%>\%
    font(color = "teal"),
  card(
    p("Aliquam posuere."),
    p("Phasellus neque orci, porta a, aliquet quis, semper a, massa."),
    p("Pellentesque dapibus suscipit ligula.")
  ) \%>\%
    border("orange"),
  card(
    header = "Phasellus lacus",
    p("Etiam laoreet quam sed arcu."),
    p("Etiam vel tortor sodales tellus ultricies commodo."),
    footer = "Nam euismod tellus id erat."
  ) \%>\%
    background("grey") \%>\%
    font(color = "indigo")
)

### Cards with list groups

column(
  width = 4,
  card(
    listGroupInput(
      id = "lg1",
      flush = TRUE,
      choices = c(
        "Pellentesque tristique imperdiet tortor.",
        "Lorem ipsum dolor sit amet, consectetuer adipiscing elit.",
        "Phasellus purus."
      ),
      values = c(
        "choice1",
        "choice2",
        "choice3"
      )
    )
  )
)

### Tabbed content in cards

card(
  header = navInput(
    id = "tabs",
    choices = c("Tab 1", "Tab 2", "Tab 3"),
    appearance = "tabs"
  ),
  navContent(
    navPane(
      "Phasellus purus.",
      "Proin neque massa, cursus ut, gravida ut, lobortis eget, lacus.",
      "Phasellus purus."
    ),
    navPane(
      "Donec at pede. Praesent augue.",
      "Pellentesque tristique imperdiet tortor."
    ),
    navPane(
      "Fusce suscipit, wisi nec facilisis facilisis,",
      "est dui fermentum leo, quis tempor ligula erat quis odio.",
      "Donec hendrerit tempor tellus."
    )
  )
)

### Deck of cards

deck(
  card(
    title = "Nullam tristique",
    p("Fusce sagittis, libero non molestie mollis, magna orci ultrices ",
      "dolor, at vulputate neque nulla lacinia eros."),
    p("Nunc rutrum turpis sed pede."),
    footer = "Cras placerat accumsan nulla."
  ),
  card(
    title = "Integer placerat",
    p("Lorem ipsum dolor sit amet, consectetuer adipiscing elit. Donec ",
      "hendrerit tempor tellus."),
    footer = "Cras placerat accumsan nulla."
  ),
  card(
    title = "Phasellus neque",
    p("Donec at pede. Etiam vel neque nec dui dignissim bibendum."),
    footer = "Cras placerat accumsan nulla."
  )
)

}
\seealso{
Other components: 
\code{\link{alert}()},
\code{\link{badge}()},
\code{\link{blockquote}()},
\code{\link{collapsePane}()},
\code{\link{d1}()},
\code{\link{dropdown}()},
\code{\link{img}()},
\code{\link{jumbotron}()},
\code{\link{modal}()},
\code{\link{navContent}()},
\code{\link{popover}()},
\code{\link{pre}()},
\code{\link{toast}()}
}
\concept{components}
