% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zenplot.R
\name{unfold}
\alias{unfold}
\title{Unfold the hypercube and produce all information concerning the zenpath
       and zenplot layout}
\usage{
unfold(nfaces, turns = NULL,
       n2dcols = c("letter", "square", "A4", "golden", "legal"),
       method = c("tidy", "double.zigzag", "single.zigzag", "rectangular"),
       first1d = TRUE, last1d = TRUE, width1d = 1, width2d = 10)
}
\arguments{
\item{nfaces}{The number of faces of the hypercube to unfold}

\item{turns}{A \code{\link{character}} vector (of length two times the
number of variables to be plotted minus 1) consisting of \code{"d"},
\code{"u"}, \code{"r"} or \code{"l"} indicating the turns out of the
current plot position; if \code{NULL}, the \code{turns} are
constructed.}

\item{n2dcols}{number of columns of 2d plots (\eqn{\ge 1}{>= 1})
or one of \code{"letter"}, \code{"square"}, \code{"A4"},
\code{"golden"} or \code{"legal"} in which case a similar layout is constructed.
Note that \code{n2dcols} is ignored if \code{!is.null(turns)}.}

\item{method}{The type of zigzag plot (a \code{\link{character}}).

Available are:
\describe{
    \item{\code{tidy}:}{more tidied-up \code{double.zigzag}
         (slightly more compact placement of plots towards the end).}
    \item{\code{double.zigzag}:}{zigzag plot in the form of a
        flipped \dQuote{S}. Along this path, the plots
        are placed in the form of an \dQuote{S} which is rotated
        counterclockwise by 90 degrees.}
    \item{\code{single.zigzag}:}{zigzag plot in the form of a
        flipped \dQuote{S}.}
    \item{\code{rectangular}:}{plots that fill the page from
        left to right and top to bottom. This is useful (and most compact)
        for plots that do not share an axis.}
}
Note that \code{method} is ignored if \code{turns} are provided.}

\item{first1d}{A \code{\link{logical}} indicating whether the first one-dimensional (1d)
plot should be plotted.}

\item{last1d}{A \code{\link{logical}} indicating whether the last one-dimensional (1d)
plot should be plotted}

\item{width1d}{A graphical parameter > 0 giving the width of 1d plots.}

\item{width2d}{A graphical parameter > 0 giving the width of 2d plots.}
}
\value{
A \code{\link{list}} describing the unfolded path and its layout
 as a list of named components:
\describe{
    \item{\code{path}:}{the path of the unfolding, itself given
    as a structured \code{\link{list}} having components
    \describe{
    \item{\code{turns}:}{the sequence of turns
     -- each being one of \dQuote{l} (for left), \dQuote{r} (for right),
    \dQuote{d} (for down), and \dQuote{u}  (for up) --
    required to move from the current plot location in the display to the next along
    the unfolded path.}
    \item{\code{positions}:}{the path as a matrix of \code{(x, y)} positions giving
     the indices in the \code{occupancy} matrix of each plot in the path.}
    \item{\code{occupancy}:}{A rectangular array whose cells indicate the positions
    of the plots on the page.}
    }
    }
    \item{\code{layout}:}{the details of the visual layout of the plots and given
    as a structured \code{\link{list}} having components
    \describe{
    \item{\code{orientations}:}{a vector indicating the orientation of each of the
    displays in order -- \dQuote{h} for horizontal, \dQuote{v} for vertical, and
    \dQuote{s} for square.}
    \item{\code{dimensions}:}{a vector giving the dimensionality of each
    plot in order.}
    \item{\code{vars}:}{A matrix of the variable indices to be used in each plot -- \code{x}
    being the horizontal variable and \code{y} the vertical.}
    \item{\code{layoutWidth}:}{A positive integer giving the display width of
    a 2d plot.}
    \item{\code{layoutHeight}:}{A positive integer giving the display height of
    a 2d plot.}
    \item{\code{boundingBoxes}:}{A matrix of 4 columns giving locations (\code{left},
    \code{right}, \code{bottom}, and \code{top}) of the box which bound each of the
    plots in order.}
    }
    }
    }
}
\description{
The \code{unfold()} function imagines each pair of variables/dimensions
as a "face" of a high dimensional cube. These faces are "unfolded" from one 2d space
or "face" to the next about the 1d face or "edge" they share.  The \code{unfold()}
function  takes, as first argument, \code{nfaces},
the number of 2d plots/spaces to be "unfolded" and produces the zenpath and
zenplot layout required for the function zenplot().  Laying out these pairs
with a zenplot is what is alluded to as an "unfolding" of (at least a part of)
the high dimensional space.
}
\note{
Although \code{unfold()} is probably rather rarely used directly by a user,
 it provides insight into how zenplots are constructed.
}
\examples{
dim <- 20
unfolding <- unfold(nfaces = dim -1)
names(unfolding)
}
\seealso{
Other creating zenplots: 
\code{\link{zenplot}()}
}
\author{
Marius Hofert and Wayne Oldford
}
\concept{creating zenplots}
