% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zetadiv.R
\name{Reg.ispline}
\alias{Reg.ispline}
\title{Perform an I-spline regression}
\usage{
Reg.ispline(
  response,
  predictor,
  order.ispline = 2,
  kn.ispline = 1,
  family = stats::gaussian(),
  method.glm = "glm.fit.cons",
  cons = 1,
  cons.inter = 1,
  control = list(),
  Plot = TRUE,
  lty = NULL,
  lwd = 1
)
}
\arguments{
\item{response}{A vector of numeric values representing the response variable.}

\item{predictor}{A data frame of numeric variables representing the predictors.}

\item{order.ispline}{Order of the I-spline.}

\item{kn.ispline}{Number of knots in the I-spline.}

\item{family}{A description of the error distribution and link function to be used in the \code{glm} model (see \code{\link[stats]{family}} for details of family functions).}

\item{method.glm}{Method used in fitting the generalised linear model. The default method \cr "glm.fit.cons" is an adaptation of method \code{glm.fit2} from package \code{glm2} using a constrained least squares regression in the reweighted least squares. Another option is "glm.fit2", which calls \code{glm.fit2}; see help documentation for glm.fit2 in package \code{glm2}.}

\item{cons}{type of constraint in the glm if \code{method.glm = "glm.fit.cons"}. Default is 1 for positive coefficients on the predictors. The other option is -1 for negative coefficients on the predictors.}

\item{cons.inter}{type of constraint for the intercept. Default is 1 for positive intercept, suitable for Gaussian family. The other option is -1 for negative intercept, suitable for binomial family.}

\item{control}{As for \code{\link{glm}}.}

\item{Plot}{Boolean value indicating if the I-splines must be plotted.}

\item{lty}{Line types to be used in the plotting. If nothing is provided, \code{lty} is a sequence of integers from 1 to the number of variables used for the computation of \code{msgdm}.}

\item{lwd}{Line width.}
}
\value{
\code{Reg.ispline} returns a list of the following elements:

\item{splines}{A data frame in which each columns contains the value resulting from the transformation of the predictors into individual I-splines. The number of columns of \code{splines} is the number of predictors times the number of splines (determined as the sum of \code{order.ispline} and \code{kn.ispline}).}

\item{spline}{A data frame in which each columns contains the value resulting from the combinations of the individual I-splines. This combination is obtained by multiplying the coefficients of \code{model} and the values of the individual I-splines \code{splines}}.

\item{model}{A \code{\link{glm}} model using \code{response} as the response variable, and \code{splines} as the predictors}.
}
\description{
Evaluates the I-splines for all variables of a data frame of predictor variables, and perform a generalised linear regression with constraint on the parameters.
}
\details{
\code{Reg.ispline} performs a non-linear regression using a combination of GLM and I-splines. It can, for example, be used to compare regression outputs when using MS-GDM with I-splines on environmental variables and biotic variables as in \code{Zetya.msgdm} to the same regression approach without environmental variables.
}
\examples{
utils::data(Marion.species)
xy.marion <- Marion.species[1:2]

data.spec.marion <- Marion.species[3:33]

##random other communities
data.spec.marion2a <- data.spec.marion
data.spec.marion2a[which(data.spec.marion2a==1,arr.ind=TRUE)] <- 0
for(i in 1:ncol(data.spec.marion2a))
  data.spec.marion2a[sample(nrow(data.spec.marion2a),8),i] <- 1
data.spec.marion2b <- data.spec.marion
data.spec.marion2b[which(data.spec.marion2b==1,arr.ind=TRUE)] <- 0
for(i in 1:ncol(data.spec.marion2b))
data.spec.marion2b[sample(nrow(data.spec.marion2b),8),i] <- 1

dat.spec.tot <- list(data.spec.marion,data.spec.marion2a,data.spec.marion2b)
zeta.tot <- Zeta.order.mc.mult(data.spec=dat.spec.tot,order=3,sam=200)
zeta.splines <- Ispline(zeta.tot$zeta.val[,2:3])
data.tot <- data.frame(zeta.val=zeta.tot$zeta.val[,1],zeta.splines$splines)

dev.new()
Reg.ispline(response = zeta.tot$zeta.val[,1], predictor = zeta.tot$zeta.val[,2:3], lwd=2, cons=1)
}
\references{
Ramsay, J. O. (1988). Monotone regression splines in action. \emph{Statistical Science}, 425-441.
}
\seealso{
\code{\link{Zeta.msgdm}},\code{\link{Ispline}}
}
