% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reference_limits.R
\name{reference_limits}
\alias{reference_limits}
\title{Calculate Reference Limits}
\usage{
reference_limits(x, probs = c(0.025, 0.975), na.rm = TRUE)
}
\arguments{
\item{x}{\code{numeric}, laboratory values}

\item{probs}{\code{numeric}, probabilities of the lower and upper reference limit,
default: \code{c(0.025, 0.975)} (spanning 95 \%).}

\item{na.rm}{\code{logical}, if \code{TRUE} (default) \code{NA} values are removed before
the reference limits are calculated.}
}
\value{
\code{numeric} of length 2 with the lower and upper limit.
}
\description{
Calculates the lower and upper reference limit for given probabilities.
}
\examples{
reference_limits(1:10)
}
\author{
Sebastian Gibb
}
