% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_detach.R
\name{index_detach}
\alias{index_detach}
\alias{index_detach.zoo}
\title{Detach index of a \code{zoo} object}
\usage{
index_detach(x, ...)

\method{index_detach}{zoo}(x, nfield = 2, ...)
}
\arguments{
\item{x}{a object.}

\item{...}{further arguments.}

\item{nfield}{numeric. Number of fields of time to retain.}
}
\value{
a data frame.
}
\description{
Detach the index of a \code{zoo} object to be seperated values of
year/month/day/hour/minute/second, and return a data frame containing
these columns.
}
\examples{

x.Date <- as.Date("2003-02-01") + c(1, 3, 7, 9, 14) - 1
x <- zoo(rnorm(5), x.Date)
index_detach(x, 3)

y.POSIXct <- ISOdatetime(2003, 02, c(1, 3, 7, 9, 14), 0, 0, 0)
y <- zoo(rnorm(5), y.POSIXct)
index_detach(y, 6)

}

