% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cor.R
\name{cor}
\alias{cor}
\alias{cor.zoo}
\alias{cor.zoocat}
\title{Correlation computing for \code{zoo} or \code{zoocat} objects}
\usage{
cor(x, y = NULL, ...)

\method{cor}{zoo}(x, y = NULL, ...)

\method{cor}{zoocat}(x, y = NULL, ...)
}
\arguments{
\item{x}{A \code{zoo} or \code{zoocat} object.}

\item{y}{NULL or a \code{zoo} or \code{zoocat} object. If NULL, x will be used.}

\item{...}{Other arguments for function \code{stats::cor}.}
}
\value{
a vector, matrix or data frame.
}
\description{
This function is based on the function \code{stats::cor}.
For \code{cor.zoo} and \code{cor.zoocat}, the equality of the \code{index} of \code{x} and \code{y} 
will be checked (if \code{y} is not \code{NULL}).
For \code{cor.zoocat}, if \code{y} has one column, the result will be binded with the 
\bold{cattr} table and a data frame will be returned.
}
\examples{

x <- zoo(c(1, 3, 2, 4, 5))
y <- zoo(c(12, 30, 2, 46, 5))
cor(x, y)

x <- matrix(1 : 20, nrow = 5)
colAttr <- data.frame(month = c(2, 3, 5, 6), name = 'x')
zc <- zoocat(x, order.by = 1991 : 1995, colattr = colAttr)
y <- zoo(c(3, 5, 4, 6, 3), order.by = 1991 : 1995)
cor(zc, y, method = 'kendall')
cor(zc, method = 'kendall')


}

