% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoomly.R
\name{zoomly}
\alias{zoomly}
\title{\code{zoomly} Class}
\usage{
zoomly(x = NULL, order.by, colattr)
}
\arguments{
\item{x}{a matrix or a vector. 
For \code{zoomly}, if x is a matrix, each row will be treated as a year. 
If x is a vector, it will be
treated as a matrix with only one column.}

\item{order.by}{a numeric vector representing years.}

\item{colattr}{a column attributes table contain a column "month".}
}
\value{
\code{zoomly} returns a \code{zoomly} object.
}
\description{
A class designed for monthly data. "\code{zoomly}" class inherits "\code{zoocat}"
class, and there is one field "month" in the column attribute (\bold{cattr}) table.
}
\examples{

x <- matrix(1 : 20, nrow = 5)
zm <- zoomly(x, order.by = 1991 : 1995, 
             colattr = data.frame(month = c(2, 3, 5, 6)))

}

