% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InCategory.R
\name{InCategory}
\alias{InCategory}
\title{Value Matching by Thesaurus Category}
\usage{
InCategory(x, category, thesaurus)
}
\arguments{
\item{x}{Character vector to be checked for its inclusion in the category.}

\item{category}{Character vector identifying the categories in which the
inclusion of \code{x} will be checked. Each category can be identified by
any equivalent name in the thesaurus.}

\item{thesaurus}{A thesaurus object.}
}
\value{
A logical vector of the same length as \code{x}. Each value answers the
question: \emph{Does the corresponding element in \code{x} belongs to any of
the thesaurus categories identified by \code{category}?}
}
\description{
Function to check if an element belongs to a category according to a
thesarus. It is similar to \code{\link[base]{\%in\%}} and
\code{\link[base]{is.element}}, returning a logical vector indicating if each
element in a given vector is included in a given set. But \code{InCategory}
checks for equality assuming the equivalencies defined in the given thesaurus.
}
\examples{
InCategory(c("sheep", "cattle", "goat", "red deer"),
           c("ovis", "capra"),
           zoologThesaurus$taxon)

}
\seealso{
\code{\link{zoologThesaurus}}, \code{\link[base]{\%in\%}}
}
