% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/euclidean_logical_joins.R
\name{euclidean_full_join}
\alias{euclidean_full_join}
\title{Spatial Full Join Using LSH}
\usage{
euclidean_full_join(
  a,
  b,
  by = NULL,
  threshold = 1,
  n_bands = 30,
  band_width = 5,
  r = 0.5,
  progress = FALSE
)
}
\arguments{
\item{a}{the first dataframe you wish to join.}

\item{b}{the second dataframe you wish to join.}

\item{by}{a named vector indicating which columns to join on. Format should
be the same as dplyr: \code{by = c("column_name_in_df_a" = "column_name_in_df_b")}, but
two columns must be specified in each dataset (x column and y column). Specification
made with \code{dplyr::join_by()} are also accepted.}

\item{threshold}{the distance threshold below which units should be considered a match}

\item{n_bands}{the number of bands used in the LSH algorithm (default
is 30). Use this in conjunction with the \code{band_width} to determine the
performance of the hashing.}

\item{band_width}{the length of each band used in the minihashing algorithm
(default is 5) Use this in conjunction with the \code{n_bands} to determine
the performance of the hashing.}

\item{r}{the r hyperparameter used to govern the sensitivity of the locality sensitive hash, as described in}

\item{progress}{set to \code{TRUE} to print progress}
}
\value{
a tibble fuzzily-joined on the basis of the variables in \code{by.} Tries
to adhere to the same standards as the dplyr-joins, and uses the same
logical joining patterns (i.e. inner-join joins and keeps only observations in both datasets).
}
\description{
Spatial Full Join Using LSH
}
\examples{
n <- 10

X_1 <- matrix(c(seq(0,1,1/(n-1)), seq(0,1,1/(n-1))), nrow=n)
X_2 <- X_1 + .0000001

X_1 <- as.data.frame(X_1)
X_2 <- as.data.frame(X_2)

X_1$id_1 <- 1:n
X_2$id_2 <- 1:n

euclidean_full_join(X_1, X_2, by = c("V1", "V2"), threshold =.00005)

}
\references{
Datar, Mayur, Nicole Immorlica, Pitor Indyk, and Vahab Mirrokni.
"Locality-Sensitive Hashing Scheme Based on p-Stable Distributions" SCG '04:
Proceedings of the twentieth annual symposium on Computational geometry
(2004): 253-262
}
