







use crate::distributions::{Distribution, Uniform};






















































#[derive(Debug, Clone, Copy)]
pub struct Slice<'a, T> {
    slice: &'a [T],
    range: Uniform<usize>,
}

impl<'a, T> Slice<'a, T> {


    pub fn new(slice: &'a [T]) -> Result<Self, EmptySlice> {
        match slice.len() {
            0 => Err(EmptySlice),
            len => Ok(Self {
                slice,
                range: Uniform::new(0, len),
            }),
        }
    }
}

impl<'a, T> Distribution<&'a T> for Slice<'a, T> {
    fn sample<R: crate::Rng + ?Sized>(&self, rng: &mut R) -> &'a T {
        let idx = self.range.sample(rng);

        debug_assert!(
            idx < self.slice.len(),
            "Uniform::new(0, {}) somehow returned {}",
            self.slice.len(),
            idx
        );




        unsafe { self.slice.get_unchecked(idx) }
    }
}



#[derive(Debug, Clone, Copy)]
pub struct EmptySlice;

impl core::fmt::Display for EmptySlice {
    fn fmt(&self, f: &mut core::fmt::Formatter<'_>) -> core::fmt::Result {
        write!(
            f,
            "Tried to create a `distributions::Slice` with an empty slice"
        )
    }
}

#[cfg(feature = "std")]
impl std::error::Error for EmptySlice {}
