% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/frontend.R
\name{check_for_status}
\alias{check_for_status}
\title{Check if the query object ends with a successful response}
\usage{
check_for_status(query)
}
\arguments{
\item{query}{A query object to check the return status of}
}
\value{
TRUE if the query succeeded, FALSE otherwise
}
\description{
Checks if a response failed as part of a query.
}
\examples{
library(ArctosR)

if (interactive()) {
  # query with an invalid column name 'paarts'
  query <- get_records(
    scientific_name = "Canis lupus", guid_prefix = "MSB:Mamm",
    columns = list("guid", "paarts", "partdetail")
  )

  check_for_status(query)
}

}
