% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{dat_bird_curr}
\alias{dat_bird_curr}
\title{Bird specific morphology dataset}
\format{
A dataframe with 1 row and 125 variables.
Only 29 required for proper operation:
\describe{
\item{total_bird_mass}{Mass of full bird for the current wing (kg)}
\item{wing_mass}{Mass of one wing, should be the current wing (kg)}
\item{barb_radius}{Radius of feather barb  for current species (m)}
\item{barb_distance}{Distance between feather barbs for current species (m)}
\item{brachial_muscle_mass}{Mass of all muscles in the brachial region
of the wing (kg)}
\item{antebrachial_muscle_mass}{Mass of all muscles in the antebrachial region
of the wing (kg)}
\item{manus_muscle_mass}{Mass of all muscles in the manus region
of the wing (kg)}
\item{all_skin_coverts_mass}{Mass of all skin and covert feathers (kg).}
\item{tertiary_mass}{Mass of tertiary feathers (kg).}
\item{extend_neck}{Logical input defining whether the neck should be
modeled as extended or not}
\item{head_length}{Length of the head from base to tip (m)}
\item{head_mass}{Mass of the head (kg)}
\item{head_height}{Height of the head at the base (m)}
\item{neck_mass}{Mass of the neck (kg)}
\item{neck_width}{OPTIONAL: Average width of the stretched neck (m)}
\item{neck_length}{OPTIONAL: Length of the stretched neck (m)}
\item{torsotail_length}{Length from the beginning of the torso to the tip of the tail (m)}
\item{torsotail_mass}{Mass of the torso and tail (kg)}
\item{tail_length}{Length of the tail (m)}
\item{tail_mass}{Mass of the tail (kg)}
\item{tail_width}{Average width of the furled tail (m)}
\item{right_leg_mass}{Mass of the right leg (kg)}
\item{left_leg_mass}{Mass of the left leg (kg)}
\item{body_width_max}{Maximum width of the torso (m)}
\item{body_width_at_leg_insert}{Width of the body at the point
where the legs are inserted (m).}
\item{x_loc_of_body_max}{x coordinate from the VRP in the
full bird frame of reference of the maximum body width (m).}
\item{x_loc_leg_insertion}{x coordinate from the VRP in the
full bird frame of reference of the leg insertion location (m).}
\item{x_loc_TorsotailCoG}{x coordinate from the VRP in the
full bird frame of reference of the center of gravity of the torso and tail (m).}
\item{z_loc_TorsotailCoG}{x coordinate from the VRP in the
full bird frame of reference of the the center of gravity of the torso and tail (m).}
}
}
\usage{
dat_bird_curr
}
\description{
A dataset containing the bird specific morphology data for a
pigeon BirdID = 20_0300, TestID = 20_03004, FrameID = 317
}
\keyword{datasets}
