% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mainrunfunctions.R
\name{massprop_restbody}
\alias{massprop_restbody}
\title{Calculate the center of gravity and moment of inertia for the head, neck,
torso and tail.}
\usage{
massprop_restbody(dat_wingID_curr, dat_bird_curr)
}
\arguments{
\item{dat_wingID_curr}{Dataframe related to the current bird wing ID
info that must include the following columns:
\itemize{
\item{species}{Species ID code as a string.}
\item{BirdID}{Bird ID code as a string.}
\item{TestID}{Test ID code as a string.}
\item{frameID}{Video frame ID code as a string.}
}}

\item{dat_bird_curr}{Dataframe related to the current bird wing that must
include the following columns:
\itemize{
\item{extend_neck}{Logical input defining whether the neck should be
modeled as extended or not.}
\item{head_length}{Length of the head from base to tip (m).}
\item{head_mass}{Mass of the head (kg).}
\item{head_height}{Height of the head at the base (m).}
\item{neck_mass}{Mass of the neck (kg).}
\item{neck_width}{OPTIONAL - Average width of the stretched neck (m).}
\item{neck_length}{OPTIONAL - Length of the stretched neck (m).}
\item{torsotail_length}{Length from the beginning of the torso to the tip of the tail (m).}
\item{torsotail_mass}{Mass of the torso and tail (kg).}
\item{tail_length}{Length of the tail (m).}
\item{tail_mass}{Mass of the tail (kg).}
\item{tail_width}{Average width of the furled tail (m).}
\item{right_leg_mass}{Mass of the right leg (kg).}
\item{left_leg_mass}{Mass of the left leg (kg).}
\item{body_width_max}{Maximum width of the torso (m).}
\item{body_width_at_leg_insert}{Width of the body at the point
where the legs are inserted (m).}
\item{x_loc_of_body_max}{x coordinate from the VRP in the
full bird frame of reference of the maximum body width (m).}
\item{x_loc_leg_insertion}{x coordinate from the VRP in the
full bird frame of reference of the leg insertion location (m).}
\item{x_loc_TorsotailCoG}{x coordinate from the VRP in the
full bird frame of reference of the center of gravity of the torso and tail (m).}
\item{z_loc_TorsotailCoG}{x coordinate from the VRP in the
full bird frame of reference of the the center of gravity of the torso and tail (m).}
}}
}
\value{
Function returns a dataframe that includes the moment of inertia and
center of gravity of head, neck, torso and tail.
}
\description{
Function that reads in anatomical data and returns the moment of inertia
tensor and center of gravity for the head, neck, tail and torso.
}
\examples{
# refer to the vignette
library(AvInertia)

# load data
data(dat_id_curr, package = "AvInertia")
data(dat_bird_curr, package = "AvInertia")
data(dat_feat_curr, package = "AvInertia")
data(dat_bone_curr, package = "AvInertia")
data(dat_mat, package = "AvInertia")
data(clean_pts, package = "AvInertia")

# 1. Determine the center of gravity of the bird's torso (including the legs)
dat_torsotail_out = massprop_restbody(dat_id_curr, dat_bird_curr)
# 2. Calculate the inertia of the flight feathers about the tip of the calamus
feather_inertia <- compute_feat_inertia(dat_mat, dat_feat_curr, dat_bird_curr)
# 3. Determine the center of gravity of one of the bird's wings
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = 0)
# Visualize the center of gravity of each wing component in the x and y axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yx")
# or the y and z axis
dat_wing_out      = massprop_birdwing(dat_id_curr, dat_bird_curr,
dat_bone_curr, dat_feat_curr, dat_mat, clean_pts,
feather_inertia, plot_var = "yz")
# 4. Combine all data and obtain the center of gravity, moment of inertia
# and principal axes of the bird
curr_full_bird      = combine_inertialprop(dat_torsotail_out,dat_wing_out,
dat_wing_out, dat_id_curr, dat_bird_curr, symmetric=TRUE)

}
