% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_methods.R
\name{create_cosmosdb_account}
\alias{create_cosmosdb_account}
\title{Create Azure Cosmos DB account}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{create_cosmosdb_account(
    name,
    location = self$location,
    interface = c("sql", "cassandra", "mongo", "table", "graph"),
    serverless = FALSE,
    free_tier = FALSE,
    properties = list(),
    ...
)
}
}

\section{Arguments}{

\itemize{
\item \code{name}: The name of the Cosmos DB account.
\item \code{location}: The location/region in which to create the account. Defaults to the resource group's location.
\item \code{interface}: The default API by which to access data in the account.
\item \code{serverless}: Whether this account should use provisioned throughput or a serverless mode. In the latter, you are charged solely on the basis of the traffic generated by your database operations. Serverless mode is best suited for small-to-medium workloads with light and intermittent traffic that is hard to forecast; it is currently (January 2021) in preview.
\item \code{free_tier}: Whether this account should be in the free tier, in which a certain amount of database operations are provided free of charge. You can have one free tier account per subscription.
\item \code{properties}: Additional properties to set for the account.
\item \code{wait}: Whether to wait until the Cosmos DB account provisioning is complete.
\item \code{...}: Optional arguments to pass to \code{az_cosmosdb$new()}.
}
}

\section{Details}{

This method creates a new Azure Cosmos DB account in the given resource group. Azure Cosmos DB is a globally distributed multi-model database that supports the document, graph, and key-value data models.

The ARM resource object provides methods for working in the management plane. For working in the data plane, AzureCosmosR provides a client framework that interfaces with the core (SQL) API. Other packages provide functionality for other APIs, such as AzureTableStor for table storage and mongolite for MongoDB.
}

\section{Value}{

An object of class \code{az_cosmosdb} representing the Cosmos DB account.
}

\seealso{
\link{get_cosmosdb_account}, \link{delete_cosmosdb_account}

For the SQL API client framework: \link{cosmos_endpoint}, \link{cosmos_database}, \link{cosmos_container}, \link{query_documents}

For the table storage API: \link[AzureTableStor:table_endpoint]{AzureTableStor::table_endpoint}

For the MongoDB API: \link{cosmos_mongo_endpoint}, \link[mongolite:mongo]{mongolite::mongo}
}
