% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/blob_lease.R
\name{acquire_lease}
\alias{acquire_lease}
\alias{break_lease}
\alias{release_lease}
\alias{renew_lease}
\alias{change_lease}
\title{Operations on blob leases}
\usage{
acquire_lease(container, blob = "", duration = 60, lease = NULL)

break_lease(container, blob = "", period = NULL)

release_lease(container, blob = "", lease)

renew_lease(container, blob = "", lease)

change_lease(container, blob = "", lease, new_lease)
}
\arguments{
\item{container}{A blob container object.}

\item{blob}{The name of an individual blob. If not supplied, the lease applies to the entire container.}

\item{duration}{For \code{acquire_lease}, The duration of the requested lease. For an indefinite duration, set this to -1.}

\item{lease}{For \code{acquire_lease} an optional proposed name of the lease; for \code{release_lease}, \code{renew_lease} and \code{change_lease}, the name of the existing lease.}

\item{period}{For \code{break_lease}, the period for which to break the lease.}

\item{new_lease}{For \code{change_lease}, the proposed name of the lease.}
}
\value{
For \code{acquire_lease} and \code{change_lease}, a string containing the lease ID.
}
\description{
Manage leases for blobs and blob containers.
}
\details{
Leasing is a way to prevent a blob or container from being accidentally deleted. The duration of a lease can range from 15 to 60 seconds, or be indefinite.
}
\seealso{
\link{blob_container},
\href{https://learn.microsoft.com/en-us/rest/api/storageservices/lease-blob}{Leasing a blob},
\href{https://learn.microsoft.com/en-us/rest/api/storageservices/lease-container}{Leasing a container}
}
