% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customvision_training.R
\name{train_model}
\alias{train_model}
\alias{list_models}
\alias{get_model}
\alias{rename_model}
\alias{delete_model}
\alias{delete_model.customvision_project}
\alias{delete_model.customvision_model}
\title{Create, retrieve, rename and delete a model iteration}
\usage{
train_model(project, training_method = c("quick", "advanced"),
  max_time = 1, force = FALSE, email = NULL, wait = (training_method ==
  "quick"))

list_models(project, as = c("ids", "list"))

get_model(project, iteration = NULL)

rename_model(model, name, ...)

delete_model(object, ...)

\method{delete_model}{customvision_project}(object, iteration = NULL, confirm = TRUE, ...)

\method{delete_model}{customvision_model}(object, confirm = TRUE, ...)
}
\arguments{
\item{project}{A Custom Vision project.}

\item{training_method}{The training method to use. The default "quick" is faster but may be less accurate. The "advanced" method is slower but produces better results.}

\item{max_time}{For advanced training, the maximum training time in hours.}

\item{force}{For advanced training, whether to refit the model even if the data has not changed since the last iteration.}

\item{email}{For advanced training, an email address to notify when the training is complete.}

\item{wait}{whether to wait until training is complete (or the maximum training time has elapsed) before returning.}

\item{as}{For \code{list_models}, the format in which to return results: as a named vector of model iteration IDs, or a list of model objects.}

\item{iteration}{For \code{get_model} and \code{delete_model.customvision_project}, either the iteration name or ID.}

\item{model}{A Custom Vision model.}

\item{name}{For \code{rename_model}, the new name for the model.}

\item{...}{Arguments passed to lower-level functions.}

\item{object}{For the \code{delete_model} method, a Custom Vision project or model, as appropriate.}

\item{confirm}{For the \code{delete_model} methods, whether to ask for confirmation first.}
}
\value{
For \code{train_model}, \code{get_model} and \code{rename_model}, an object of class \code{customvision_model} which is a handle to the iteration.

For \code{list_models}, based on the \code{as} argument: \code{as="ids"} returns a named vector of model iteration IDs, while \code{as="list"} returns a list of model objects.
}
\description{
Create, retrieve, rename and delete a model iteration
}
\details{
Training a Custom Vision model results in a \emph{model iteration}. Each iteration is based on the current set of images uploaded to the endpoint. Successive model iterations trained on different image sets do not overwrite previous ones.

You must have at least 5 images per tag for a classification project, and 15 images per tag for an object detection project, before you can train a model.

By default, AzureVision will use the latest model iteration for actions such as prediction, showing performance statistics, and so on. You can list the model iterations with \code{list_models}, and retrieve a specific iteration by passing the iteration ID to \code{get_model}.
}
\examples{
\dontrun{

endp <- customvision_training_endpoint(url="endpoint_url", key="key")
myproj <- get_project(endp, "myproject")

train_model(myproj)
train_model(myproj, method="advanced", force=TRUE, email="me@example.com")

list_models(myproj)

mod <- get_model(myproj)
rename(mod, "mymodel")
mod <- get_model(myproj, "mymodel")

delete_model(mod)

}
}
\seealso{
\code{\link{show_model}}, \code{\link{show_training_performance}}, \code{\link{publish_model}}
}
