% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/customvision_training.R
\name{show_model}
\alias{show_model}
\alias{show_training_performance}
\alias{summary.customvision_model}
\title{Display model iteration details}
\usage{
show_model(model)

show_training_performance(model, threshold = 0.5, overlap = NULL)

\method{summary}{customvision_model}(object, ...)
}
\arguments{
\item{model, object}{A Custom Vision model iteration object.}

\item{threshold}{For a classification model, the probability threshold to assign an image to a class.}

\item{overlap}{For an object detection model, the overlap threshold for distinguishing between overlapping objects.}

\item{...}{Arguments passed to lower-level functions.}
}
\value{
For \code{show_model}, a list containing the metadata for the model iteration. For \code{show_training_performance} and \code{summary.customvision_model}, a list of performance diagnostics.
}
\description{
Display model iteration details
}
\details{
\code{show_model} displays the metadata for a model iteration: the name (assigned by default), model training status, publishing details, and so on. \code{show_training_performance} displays summary statistics for the model's performance on the training data. The \code{summary} method for Custom Vision model objects simply calls \code{show_training_performance}.
}
\examples{
\dontrun{

endp <- customvision_training_endpoint(url="endpoint_url", key="key")
myproj <- get_project(endp, "myproject")
mod <- get_model(myproj)

show_model(mod)

show_training_performance(mod)
summary(mod)

}
}
\seealso{
\code{\link{train_model}}
}
