% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.bass}
\alias{predict.bass}
\title{BASS Prediction}
\usage{
\method{predict}{bass}(
  object,
  newdata,
  newdata.func = NULL,
  mcmc.use = NULL,
  verbose = FALSE,
  nugget = FALSE,
  ...
)
}
\arguments{
\item{object}{a fitted model, output from the \code{bass} function.}

\item{newdata}{a matrix of new input values at which to predict.  The columns should correspond to the same variables used in the \code{bass} function.}

\item{newdata.func}{a matrix of new values of the functional variable.  If none, the same values will be used as in the training data.}

\item{mcmc.use}{a vector indexing which MCMC iterations to use for prediction.}

\item{verbose}{logical; should progress be displayed?}

\item{nugget}{logical; should predictions include error? If FALSE, predictions will be for mean.}

\item{...}{further arguments passed to or from other methods.}
}
\value{
If model output is a scalar, this returns a matrix with the same number of rows as \code{newdata} and columns corresponding to the the MCMC iterations \code{mcmc.use}.  These are samples from the posterior predictive distribution.  If model output is functional, this returns an array with first dimension corresponding to MCMC iteration, second dimension corresponding to the rows of \code{newdata}, and third dimension corresponding to the rows of \code{newdata.func}.
}
\description{
Predict function for BASS.  Outputs the posterior predictive samples based on the specified MCMC iterations.
}
\details{
Efficiently predicts when two MCMC iterations have the same basis functions (but different weights).
}
\examples{
# See examples in bass documentation.

}
\seealso{
\link{bass} for model fitting and \link{sobol} for sensitivity analysis.
}
