% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ceplane.plot.R
\name{ceplane.plot.bcea}
\alias{ceplane.plot.bcea}
\alias{ceplane.plot}
\title{Cost-effectiveness Plane Plot}
\usage{
\method{ceplane.plot}{bcea}(
  he,
  comparison = NULL,
  wtp = 25000,
  pos = "topleft",
  graph = options("bcea.graph"),
  ...
)

ceplane.plot(he, ...)
}
\arguments{
\item{he}{A \code{bcea} object containing the results of the Bayesian
modelling and the economic evaluation.}

\item{comparison}{Selects the comparator, in case of more than two
interventions being analysed. Default as \code{NULL} plots all the
comparisons together. Any subset of the possible comparisons can be selected
(e.g., \code{comparison = c(1,3)} or \code{comparison = 2}).}

\item{wtp}{The value of the willingness to pay parameter. Not used if
\code{graph = "base"} for multiple comparisons. For \pkg{ggplot2} and \pkg{plotly} can also provide
a list of arguments for more options (see below).}

\item{pos}{Parameter to set the position of the legend; for a single
comparison plot, the ICER legend position. Can be given in form of a string
\code{(bottom|top)(right|left)} for base graphics and
\code{bottom|top|left|right} for \pkg{ggplot2}. It can be a two-elements vector,
which specifies the relative position on the x and y axis respectively, or
alternatively it can be in form of a logical variable, with \code{FALSE}
indicating to use the default position and \code{TRUE} to place it on the
bottom of the plot. Default value is \code{c(1,1)}, that is the topright
corner inside the plot area.}

\item{graph}{A string used to select the graphical engine to use for
plotting. Should (partial-) match the three options \code{"base"},
\code{"ggplot2"} or \code{"plotly"}. Default value is \code{"base"}. This is set globally
upon loading \code{BCEA} and can be modified for instance by using
\code{options("bcea.graph"="gg")}, or \verb{options("bcea.graph="plotly")}. Partial
matching still applies (so \code{gg} or \code{pl} also work). Not all plotting
functions have a \code{"plotly"} implementation, yet -- see help for the specifics.}

\item{...}{If \code{graph = "ggplot2"} and a named theme object is supplied,
it will be passed to the \pkg{ggplot2} object. The usual ggplot2 syntax is used.
Additional graphical arguments:
\itemize{
\item \code{label.pos = FALSE}: Places the willingness-to-pay label in a
different position at the bottom of the graph. Applies to base and
\pkg{ggplot2} only (no label in \pkg{plotly}).
\item \code{line = list(color)}: A colour specifying the colour of the
willingness-to-pay line (not available in the \pkg{plotly} version).
\item \code{point = list(color)}: A vector of colours specifying the colour(s)
associated with the cloud of points. Should be of length 1 or equal
to the number of comparisons.
\item \code{point = list(size)}: A vector specifying the size(s) of the points.
Should be of length 1 or equal to the number of comparisons.
\item \code{point = list(shape)}: A vector specifying the shape(s) of the points.
Should be of length 1 or equal to the number of comparisons.
\item \code{icer = list(color)}: A vector of colours specifying the colour(s) of
the ICER points. Should be of length 1 or equal to the number of comparisons.
\item \code{icer = list(size)}: A vector specifying the size(s) of the ICER points.
Should be of length 1 or equal to the number of comparisons.
\item \code{area_include}: Logical. Include or exclude the cost-effectiveness
acceptability area (default is \code{TRUE}).
\item \code{wtp = list(value)}: Equivalent to using \code{wtp = value} but for when
multiple arguments are passed in list form.
\item \code{area = list(color)}: A colour specifying the colour of the
cost-effectiveness acceptability area.
\item \code{wtp = list(color)}: A colour specifying the colour of the
willingness-to-pay text.
\item \code{wtp = list(size)}: A value specifying the size of the
willingness-to-pay text.
\item \code{wtp = list(x=..., y=...)}: Values specifying the x and y coordinates
of the willingness-to-pay text (not displayed in the \pkg{plotly} version).
\item \code{currency}: Currency prefix to cost differential values. Applies to
\pkg{ggplot2} only.
\item \code{icer_annot}: Annotates each ICER point with a text label. Applies to
\pkg{ggplot2} only.
}}
}
\value{
If \code{graph = "ggplot2"} a ggplot object, or if \code{graph = "plotly"}
a plotly object containing the requested plot. Nothing is returned when
\code{graph = "base"}, the default.

Grey dots show the simulated values for the joint
distribution of the effectiveness and cost differentials. The larger red
dot shows the ICER and the grey area identifies the sustainability area,
i.e. the part of the plan for which the simulated values are below the
willingness to pay threshold. The proportion of points in the sustainability
area effectively represents the CEAC for a given value of the willingness to
pay. If the comparators are more than 2 and no pairwise comparison is
specified, all scatterplots are graphed using different colours.
}
\description{
Produces a scatter plot of the cost-effectiveness plane,
together with the sustainability area, as a function of
the selected willingness to pay threshold.
}
\details{
In the \pkg{plotly} version, colors can also
be specified as rgba colours using either the \verb{[plotly]toRGB}
function or a rgba colour string, e.g. \code{'rgb(1, 1, 1, 1)'}.
}
\examples{
## create the bcea object for the smoking cessation example
data(Smoking)

m <- bcea(eff, cost, ref = 4, Kmax = 500, interventions = treats)

## produce the base plot
ceplane.plot(m, wtp = 200, graph = "base")

## select only one comparator
ceplane.plot(m, wtp = 200, graph = "base", comparison = 3)

## use ggplot2
if (requireNamespace("ggplot2")) {
   ceplane.plot(m, wtp = 200, pos = "right", icer = list(size = 2), graph = "ggplot2")
}

## plotly
ceplane.plot(m, wtp = 200, graph = "plotly")
ceplane.plot(m, wtp = 200, comparison = 1, graph = "plotly")
 
}
\references{
\insertRef{Baio2011}{BCEA}

\insertRef{Baio2013}{BCEA}
}
\seealso{
\code{\link[=bcea]{bcea()}},
\code{\link[=ceplane_plot_graph]{ceplane_plot_graph()}}
}
\author{
Gianluca Baio, Andrea Berardi
}
\keyword{hplot}
