% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sparseFactor.R
\name{BClustLonG}
\alias{BClustLonG}
\title{A Dirichlet process mixture model for clustering longitudinal gene expression data.}
\usage{
BClustLonG(
  data = NULL,
  iter = 20000,
  thin = 2,
  savePara = FALSE,
  infoVar = c("both", "int")[1],
  factor = TRUE,
  hyperPara = list(v1 = 0.1, v2 = 0.1, v = 1.5, c = 1, a = 0, b = 10, cd = 1, aa1 = 2,
    aa2 = 1, alpha0 = -1, alpha1 = -1e-04, cutoff = 1e-04, h = 100)
)
}
\arguments{
\item{data}{Data list with three elements: Y (gene expression data with
each column being one gene), ID, and years.
(The names of the elements have to be matached exactly.
See the data in the example section more info)}

\item{iter}{Number of iterations (excluding the thinning).}

\item{thin}{Number of thinnings.}

\item{savePara}{Logical variable indicating if all the parameters needed to be saved.
Default value is FALSE, in which case only the membership indicators are saved.}

\item{infoVar}{Either "both" (using both intercepts and slopes for clustering)
or "int" (using only intercepts for clustering)}

\item{factor}{Logical variable indicating whether factor analysis model is wanted.}

\item{hyperPara}{A list of hyperparameters with default values.}
}
\value{
returns a list with following objects.
\item{e.mat}{Membership indicators from all iterations.}
\item{All other parameters}{only returned when savePara=TRUE.}
}
\description{
A Dirichlet process mixture model for clustering longitudinal gene expression data.
}
\examples{
data(data)
## increase the number of iterations
## to ensure convergence of the algorithm

res = BClustLonG(data, iter=20, thin=2,savePara=FALSE,
infoVar="both",factor=TRUE)
## discard the first 10 burn-ins in the e.mat
## and calculate similarity matrix
## the number of burn-ins has be chosen s.t. the algorithm is converged.
mat = calSim(t(res$e.mat[,11:20]))
clust = maxpear(mat)$cl ## the clustering results.
\dontrun{
## if only want to include intercepts for clustering
## set infoVar="int"
res = BClustLonG(data, iter=10, thin=2,savePara=FALSE,
infoVar="int",factor=TRUE)

## if no factor analysis model is wanted
## set factor=FALSE
res = BClustLonG(data, iter=10, thin=2,savePara=FALSE,
infoVar="int",factor=TRUE)
}
}
\references{
Jiehuan Sun, Jose D. Herazo-Maya, Naftali Kaminski, Hongyu Zhao,
and Joshua L. Warren. "A Dirichlet process mixture model for clustering
longitudinal gene expression data." Statistics in Medicine 36, No. 22 (2017): 3495-3506.
}
