% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/precision.R
\name{precision}
\alias{precision}
\title{Precision Matrix Posterior Distribution}
\usage{
precision(object, progress = TRUE)
}
\arguments{
\item{object}{An object of class \code{estimate}.}

\item{progress}{Logical. Should a progress bar be included (defaults to \code{TRUE}) ?}
}
\value{
\itemize{

\item \code{precision_mean} The mean of the precision matrix (\code{p} by \code{p} matrix).

\item \code{precision} 3d array of dimensions \code{p} by \code{p} by \code{iter}
including \strong{unconstrained} (i.e., from th full graph)
precision matrices.

}
}
\description{
Transform the sampled correlation matrices to
precision matrices (i.e., inverse covariance matrices).
}
\note{
The estimated precision matrix is the inverse of the \strong{correlation} matrix.
}
\examples{
\donttest{
# data
Y <- ptsd

# fit model
fit <- estimate(Y)

# precision matrix
Theta <- precision(fit)

}

}
