% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/madc2gmat.R
\name{madc2gmat}
\alias{madc2gmat}
\title{Convert MADC Files to an Additive Genomic Relationship Matrix}
\usage{
madc2gmat(
  madc_file,
  seed = NULL,
  method = "collapsed",
  ploidy,
  output.file = NULL
)
}
\arguments{
\item{madc_file}{Path to the MADC file to be filtered}

\item{seed}{Optional seed for random number generation (default is NULL)}

\item{method}{Method to use for processing the MADC data. Options are "unique" or "collapsed". Default is "collapsed".}

\item{ploidy}{Numeric. Ploidy level of the samples (e.g., 2 for diploid, 4 for tetraploid)}

\item{output.file}{Path to save the filtered data (if NULL, data will not be saved)}
}
\value{
data.frame or saved csv file
}
\description{
Scale and normalize MADC read count data and convert it to an additive genomic relationship matrix.
}
\details{
This function reads a MADC file, processes it to remove unnecessary columns, and then
converts it into an additive genomic relationship matrix using the first method proposed by VanRaden (2008).
The resulting matrix can be used for genomic selection or other genetic analyses.
}
\examples{
#Input variables
madc_file <- system.file("example_MADC_FixedAlleleID.csv", package="BIGr")

#Calculations
temp <- tempfile()

# Converting to additive relationship matrix
gmat <- madc2gmat(madc_file,
                 seed = 123,
                 ploidy=2,
                 output.file = NULL)

}
\references{
VanRaden, P. M. (2008). Efficient methods to compute genomic predictions. Journal of Dairy Science, 91(11), 4414-4423
}
\author{
Alexander M. Sandercock
}
