% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kernels.R
\name{KernelComposed}
\alias{KernelComposed}
\title{R6 class for Composed Kernels}
\description{
R6 class for Composed Kernels
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Create a new locally periodic kernel
k_loc_per <- KernelComposed$new(
  left_kernel = KernelSE$new(),
  right_kernel = KernelPeriodic$new(),
  new_name = 'Locally Periodic Kernel',
  composition_operation = CompositionOps$MUL
)
# Set the kernel's positions
positions_df <- data.frame(x=c(-4, 0, 3), y=c(-2, 0, 2))
k_loc_per$set_positions(positions_df)
# Generate the kernel's covariance matrix
k_loc_per$kernel_gen()
\dontshow{\}) # examplesIf}
}
\section{Super class}{
\code{\link[BKTR:Kernel]{BKTR::Kernel}} -> \code{KernelComposed}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{The kernel's name}

\item{\code{parameters}}{The parameters of the kernel (list of \code{KernelParameter})}

\item{\code{left_kernel}}{The left kernel to use for composition}

\item{\code{right_kernel}}{The right kernel to use for composition}

\item{\code{composition_operation}}{The operation to use for composition}

\item{\code{has_dist_matrix}}{Identify if the kernel has a distance matrix or not}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-KernelComposed-new}{\code{KernelComposed$new()}}
\item \href{#method-KernelComposed-core_kernel_fn}{\code{KernelComposed$core_kernel_fn()}}
\item \href{#method-KernelComposed-set_positions}{\code{KernelComposed$set_positions()}}
\item \href{#method-KernelComposed-clone}{\code{KernelComposed$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="BKTR" data-topic="Kernel" data-id="add_jitter_to_kernel"><a href='../../BKTR/html/Kernel.html#method-Kernel-add_jitter_to_kernel'><code>BKTR::Kernel$add_jitter_to_kernel()</code></a></span></li>
<li><span class="pkg-link" data-pkg="BKTR" data-topic="Kernel" data-id="kernel_gen"><a href='../../BKTR/html/Kernel.html#method-Kernel-kernel_gen'><code>BKTR::Kernel$kernel_gen()</code></a></span></li>
<li><span class="pkg-link" data-pkg="BKTR" data-topic="Kernel" data-id="plot"><a href='../../BKTR/html/Kernel.html#method-Kernel-plot'><code>BKTR::Kernel$plot()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelComposed-new"></a>}}
\if{latex}{\out{\hypertarget{method-KernelComposed-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{KernelComposed} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelComposed$new(left_kernel, right_kernel, new_name, composition_operation)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{left_kernel}}{Kernel: The left kernel to use for composition}

\item{\code{right_kernel}}{Kernel: The right kernel to use for composition}

\item{\code{new_name}}{String: The name of the composed kernel}

\item{\code{composition_operation}}{CompositionOps: The operation to use for composition}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelComposed-core_kernel_fn"></a>}}
\if{latex}{\out{\hypertarget{method-KernelComposed-core_kernel_fn}{}}}
\subsection{Method \code{core_kernel_fn()}}{
Method to compute the core kernel's covariance matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelComposed$core_kernel_fn()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The core kernel's covariance matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelComposed-set_positions"></a>}}
\if{latex}{\out{\hypertarget{method-KernelComposed-set_positions}{}}}
\subsection{Method \code{set_positions()}}{
Method to set the kernel's positions and compute the distance matrix
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelComposed$set_positions(positions_df)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{positions_df}}{Dataframe: The positions of the points in a dataframe format}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
NULL, set the kernel's positions and compute the distance matrix
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-KernelComposed-clone"></a>}}
\if{latex}{\out{\hypertarget{method-KernelComposed-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{KernelComposed$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
